/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.facade.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.quartz.param.AddPostClickCountParam;
import com.bxm.localnews.quartz.param.InviteExpireTaskParam;
import com.bxm.localnews.quartz.param.MonitorTaskBuildParam;
import com.bxm.localnews.quartz.param.PublishNewsBuildParam;
import com.bxm.localnews.quartz.param.PushMsgBuildParam;
import com.bxm.localnews.quartz.param.UserTopPostBuildParam;
import com.bxm.localnews.quartz.runtime.AddPostClickCountTask;
import com.bxm.localnews.quartz.runtime.InviteRelationshipTask;
import com.bxm.localnews.quartz.runtime.NewsMonitorTask;
import com.bxm.localnews.quartz.runtime.PublishNewsTask;
import com.bxm.localnews.quartz.runtime.PushMessageTask;
import com.bxm.localnews.quartz.runtime.UserTopPostTask;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.quartz.service.ScheduleJobService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-1"}, description="\u5b9a\u65f6\u4efb\u52a1\u6784\u5efa\u76f8\u5173\u670d\u52a1\u63a5\u53e3")
@RestController
@RequestMapping(value={"quartz"})
public class QuartzManageController {
    private static final Logger log = LoggerFactory.getLogger(QuartzManageController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzManageController.class);
    private final ScheduleJobService scheduleJobService;

    @Autowired
    public QuartzManageController(ScheduleJobService scheduleJobService) {
        this.scheduleJobService = scheduleJobService;
    }

    @ApiOperation(value="1-1-1 \u6784\u5efa\u65b0\u95fb\u76d1\u63a7\u7684\u5b9a\u65f6\u4efb\u52a1", notes="\u6839\u636e\u914d\u7f6e\u7684\u76d1\u63a7\u6761\u4ef6\u6784\u5efa\u6301\u7eed\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/add/monitor"})
    public ResponseEntity<String> createMonitorTask(@RequestBody MonitorTaskBuildParam param) {
        NewsMonitorTask task = new NewsMonitorTask();
        task.setJobName(task.getJobName() + param.getIndexId());
        String cronExpression = "0 0 " + param.getFireTime() + " * * ?";
        LOGGER.debug("\u76d1\u63a7\u8868\u8fbe\u5f0f\uff1a[{}]", (Object)cronExpression);
        task.setCron(cronExpression);
        task.addParam("parameter", (Object)param);
        Message message = this.scheduleJobService.addCronJob((AbstractCustomJob)task);
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)message.getLashMessaage());
    }

    @ApiOperation(value="1-1-2 \u79fb\u9664\u65b0\u95fb\u76d1\u63a7\u7684\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/remove/monitor"})
    public ResponseEntity<String> removeMonitorTask(@RequestParam Long indexId) {
        NewsMonitorTask task = new NewsMonitorTask();
        Message message = this.scheduleJobService.remove(task.getJobName() + indexId, task.getGroup());
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)message.getLashMessaage());
    }

    @ApiOperation(value="1-1-3 \u6dfb\u52a0\u65b0\u95fb\u53d1\u5e03\u7684\u5b9a\u65f6\u4efb\u52a1\uff08\u4ec5\u8fd0\u884c\u4e00\u6b21\uff09", notes="\u8fd0\u8425\u540e\u53f0\u8fdb\u884c\u5b9a\u65f6\u53d1\u5e03\u65f6\u8c03\u7528")
    @PostMapping(value={"/add/publish"})
    public ResponseEntity<String> createPublishNewsTask(@RequestBody PublishNewsBuildParam param) {
        PublishNewsTask task = new PublishNewsTask();
        task.setJobName(task.getJobName() + "_" + param.getNewsId());
        task.addParam("parameter", (Object)param);
        task.setStartTime(param.getStartTime());
        if (this.scheduleJobService.getJob(task.getJobName(), task.getGroup()) != null) {
            this.scheduleJobService.remove(task.getJobName(), task.getGroup());
        }
        LOGGER.warn(" \u6dfb\u52a0\u65b0\u95fb\u53d1\u5e03\u7684\u5b9a\u65f6\u4efb\u52a1\uff08\u4ec5\u8fd0\u884c\u4e00\u6b21\uff09:{}", (Object)JSON.toJSONString((Object)task));
        Message message = this.scheduleJobService.addSimpleJob((AbstractCustomJob)task);
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)message.getLashMessaage());
    }

    @ApiOperation(value="1-1-4 \u6dfb\u52a0\u6d88\u606f\u63a8\u9001\u7684\u5b9a\u65f6\u4efb\u52a1(\u4ec5\u8fd0\u884c\u4e00\u6b21)", notes="\u8fd0\u8425\u540e\u53f0\u914d\u7f6e\u4e86\u5b9a\u65f6push\u65f6\uff0c\u8fdb\u884c\u5b9a\u65f6\u63a8\u9001")
    @PostMapping(value={"/add/push"})
    public ResponseEntity<String> createPushMsgTask(@RequestBody PushMsgBuildParam param) {
        Message message;
        PushMessageTask task = new PushMessageTask();
        task.setJobName(task.getJobName() + "_" + param.getMessageId());
        task.addParam("parameter", (Object)param);
        task.setStartTime(param.getStartTime());
        if (this.scheduleJobService.getJob(task.getJobName(), task.getGroup()) != null) {
            this.scheduleJobService.remove(task.getJobName(), task.getGroup());
        }
        if ((message = this.scheduleJobService.addSimpleJob((AbstractCustomJob)task)).isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)message.getLashMessaage());
    }

    @ApiOperation(value="1-1-5 \u79fb\u9664\u63a8\u9001\u7684\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/remove/push"})
    public ResponseEntity<String> removePushTask(@RequestParam Long messageId) {
        PushMessageTask task = new PushMessageTask();
        log.debug("\u5220\u9664\u6d88\u606f[{}]\u7684\u5b9a\u65f6\u4efb\u52a1", (Object)messageId);
        Message message = this.scheduleJobService.remove(task.getJobName() + "_" + messageId, task.getGroup());
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)message.getLashMessaage());
    }

    @ApiOperation(value="1-1-6 \u6dfb\u52a0\u89e3\u9664\u9080\u8bf7\u5173\u7cfb\u7684\u5b9a\u65f6\u4efb\u52a1(\u4ec5\u8fd0\u884c\u4e00\u6b21)")
    @PostMapping(value={"/add/invite"})
    public ResponseEntity<String> createInviteTask(@RequestBody InviteExpireTaskParam param) {
        InviteRelationshipTask task = new InviteRelationshipTask();
        task.setJobName(task.getJobName() + "_" + param.getJobId());
        task.addParam("parameter", (Object)param);
        task.setStartTime(param.getStartTime());
        if (this.scheduleJobService.getJob(task.getJobName(), task.getGroup()) != null) {
            return ResponseEntity.ok().build();
        }
        Message message = this.scheduleJobService.addSimpleJob((AbstractCustomJob)task);
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)message.getLashMessaage());
    }

    @ApiOperation(value="1-1-7 \u79fb\u9664\u9080\u8bf7\u7684\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/remove/invite"})
    public ResponseEntity<String> removeInviteTask(String jobId) {
        InviteRelationshipTask task = new InviteRelationshipTask();
        Message message = this.scheduleJobService.remove(task.getJobName() + "_" + jobId, task.getGroup());
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)message.getLashMessaage());
    }

    @ApiOperation(value="1-1-8 \u6dfb\u52a0\u5b9a\u65f6\u6e05\u7406\u7528\u6237\u5e16\u5b50\u7f6e\u9876\u5f00\u59cb\u6267\u884c")
    @PostMapping(value={"/remove/user/post"})
    public ResponseEntity<String> removePostUserTopTask(@RequestBody UserTopPostBuildParam userTopPostBuildParam) {
        UserTopPostTask task = new UserTopPostTask();
        task.setJobName(task.getJobName() + "_" + userTopPostBuildParam.getPostId());
        task.addParam("parameter", (Object)userTopPostBuildParam);
        task.setStartTime(DateUtils.addField((Date)userTopPostBuildParam.getAddTime(), (int)10, (int)1));
        if (this.scheduleJobService.getJob(task.getJobName(), task.getGroup()) != null) {
            return ResponseEntity.ok().build();
        }
        LOGGER.warn(" \u6dfb\u52a0\u5b9a\u65f6\u6e05\u7406\u7528\u6237\u5e16\u5b50\u7f6e\u9876\u7684\u5b9a\u65f6\u4efb\u52a1\uff08\u4ec5\u8fd0\u884c\u4e00\u6b21\uff09:{}", (Object)JSON.toJSONString((Object)task));
        Message message = this.scheduleJobService.addSimpleJob((AbstractCustomJob)task);
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)message.getLashMessaage());
    }

    @ApiOperation(value="1-1-9 \u6dfb\u52a0\u5b9a\u65f6\u589e\u52a0\u5e16\u5b50\u70b9\u51fb\u6570\u7684\u5b9a\u65f6\u4efb\u52a1(\u4ec5\u8fd0\u884c\u4e00\u5929)")
    @PostMapping(value={"/add/postClick"})
    public ResponseEntity<String> createPostClickTask(@RequestBody AddPostClickCountParam param) {
        AddPostClickCountTask task = new AddPostClickCountTask();
        Calendar now = Calendar.getInstance();
        task.setJobName(task.getJobName() + "_" + param.getPostId());
        param.setEndTime(DateUtils.addField((Date)now.getTime(), (int)5, (int)1));
        task.addParam("parameter", (Object)param);
        String cronExpression = now.get(13) + " " + now.get(12) + " * * * ?";
        LOGGER.debug("\u4efb\u52a1\u8868\u8fbe\u5f0f\uff1a[{}]", (Object)cronExpression);
        task.setCron(cronExpression);
        if (this.scheduleJobService.getJob(task.getJobName(), task.getGroup()) != null) {
            return ResponseEntity.ok().build();
        }
        Message message = this.scheduleJobService.addCronJob((AbstractCustomJob)task);
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)message.getLashMessaage());
    }
}

