/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.integration;

import com.bxm.localnews.quartz.facade.NewsFeignService;
import com.bxm.localnews.quartz.param.MonitorTaskBuildParam;
import com.bxm.localnews.quartz.param.OptimizationNoticeParam;
import com.bxm.localnews.quartz.vo.CalculatePost;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class NewsIntegrationService {
    @Autowired
    NewsFeignService newsService;

    public Integer countNews(MonitorTaskBuildParam monitorTaskBuildParam) {
        ResponseEntity<Integer> result = this.newsService.countNews(monitorTaskBuildParam);
        if (null == result) {
            return 0;
        }
        return (Integer)result.getBody();
    }

    public void syncMykindToData() {
        this.newsService.syncMykindToData();
    }

    public void publishMarketingActivities() {
        this.newsService.publishMarketingActivities();
    }

    public void publishNews(Long newsId) {
        this.newsService.publishNews(newsId);
    }

    public void checkHotNewsExpire() {
        this.newsService.checkHotNewsExpire();
    }

    public void updateMonitorStatus(Long id, int status, String message) {
        this.newsService.updateMonitorStatus(id, status, message);
    }

    public void updateNewsReplyStatus() {
        this.newsService.updateNewsReplyStatus();
    }

    public void calcParticipantsNum() {
        this.newsService.calcParticipantsNum();
    }

    public void addPostClick(Long postId, Long clickCount) {
        this.newsService.addPostClick(postId, clickCount);
    }

    public CalculatePost getCalculatePost() {
        return this.newsService.calculatePostCount();
    }

    public Boolean sendOptimizationNotice(OptimizationNoticeParam parameter) {
        return this.newsService.optimizationNotice(parameter);
    }
}

