package com.bxm.localnews.quartz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;


@ApiModel(description = "营销活动")
public class MarketingActivities {
    @ApiModelProperty(value = "主键")
    protected Long id;
    @ApiModelProperty(value = "标题")
    protected String title;
    @ApiModelProperty(value = "作者")
    protected String author;
    @ApiModelProperty(value = "来源")
    protected String source;
    @ApiModelProperty(value = "封面图")
    protected String coverUrl;
    @ApiModelProperty(value = "外链地址")
    protected String linkUrl;
    @ApiModelProperty(value = "内容")
    protected String content;
    @ApiModelProperty(value = "内容类型 1:外链 2:富文本")
    protected Integer contentType;
    @ApiModelProperty(value = "创建账户")
    protected String createAccount;
    @ApiModelProperty(value = "创建时间")
    protected Date createTime;
    @ApiModelProperty(value = "发布时间")
    protected Date publishTime;
    @ApiModelProperty(value = "展示时间")
    protected Date showTime;
    @ApiModelProperty(value = "投放类别 0:全国 1:区域")
    protected Integer deliveryType;
    @ApiModelProperty(value = "投放频道（当前版本默认36 推荐频道）")
    protected Integer deliveryChannel;
    @ApiModelProperty(value = "标签 0：置顶 1：热 3：活动 4：本地 99：普通信息流")
    protected Integer showLevel;
    @ApiModelProperty(value = "状态 0：缺省 待发布 -1 下线 1上线")
    protected Integer status;
    @ApiModelProperty(value = "标签详情 （多个标签逗号间隔）")
    protected String showLevelDetail;
    @ApiModelProperty(value = "地区详情")
    protected String areaDetail;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getCoverUrl() {
        return coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public String getCreateAccount() {
        return createAccount;
    }

    public void setCreateAccount(String createAccount) {
        this.createAccount = createAccount;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Date getShowTime() {
        return showTime;
    }

    public void setShowTime(Date showTime) {
        this.showTime = showTime;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Integer getDeliveryChannel() {
        return deliveryChannel;
    }

    public void setDeliveryChannel(Integer deliveryChannel) {
        this.deliveryChannel = deliveryChannel;
    }

    public Integer getShowLevel() {
        return showLevel;
    }

    public void setShowLevel(Integer showLevel) {
        this.showLevel = showLevel;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getShowLevelDetail() {
        return showLevelDetail;
    }

    public void setShowLevelDetail(String showLevelDetail) {
        this.showLevelDetail = showLevelDetail;
    }

    public String getAreaDetail() {
        return areaDetail;
    }

    public void setAreaDetail(String areaDetail) {
        this.areaDetail = areaDetail;
    }
}
