package com.bxm.localnews.quartz.vo;

import java.io.Serializable;
import java.util.Date;

/**
 * t_news_pool
 * @author 
 */
public class NewsPool implements Serializable {
    private Long id;

    /**
     * 新闻标题
     */
    private String title;

    /**
     * 新闻网络图片地址（json字符串格式）
     */
    private String imgUrl;

    /**
     * 在头条里面的ID
     */
    private String groupId;

    /**
     * 组图类型--图片张数
     */
    private Integer imgNum;

    /**
     * 图片列表
     */
    private String imagesList;

    /**
     * 视频长度 单位秒
     */
    private Integer videoLen;

    /**
     * 主题词 多个之间用逗号隔开
     */
    private String theme;

    /**
     * 作者头像
     */
    private String authorImg;

    /**
     * 来源作者
     */
    private String author;

    /**
     * 来源地址
     */
    private String address;

    /**
     * 视频播放地址
     */
    private String videoAddress;

    /**
     * 分类id（一篇文章对应一个分类）
     */
    private Integer kindId;

    /**
     * 分享次数
     */
    private Long shares;

    /**
     * 浏览次数
     */
    private Long views;

    /**
     * 新增时间（抓取时间）
     */
    private Date addTime;

    /**
     * 发布时间
     */
    private Date issueTime;

    /**
     * 状态 0:抓取中 1：可用  2：失效
     */
    private Byte status;

    /**
     * 标签
     */
    private String label;

    /**
     * 是否置顶 1：否 2：是
     */
    private Byte top;

    /**
     * 新闻类型  1：文章  2：组图  3：视频
     */
    private Byte type;

    /**
     * 新闻渠道 1：今日头条 2：搜狐 3:凤凰 4:UC,5网易,6猫扑,7快资讯
     */
    private Byte channel;

    /**
     * 是否是热文 1：否  2：是
     */
    private Byte hot;

    /**
     * 内容
     */
    private String content;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Integer getImgNum() {
        return imgNum;
    }

    public void setImgNum(Integer imgNum) {
        this.imgNum = imgNum;
    }

    public String getImagesList() {
        return imagesList;
    }

    public void setImagesList(String imagesList) {
        this.imagesList = imagesList;
    }

    public Integer getVideoLen() {
        return videoLen;
    }

    public void setVideoLen(Integer videoLen) {
        this.videoLen = videoLen;
    }

    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getAuthorImg() {
        return authorImg;
    }

    public void setAuthorImg(String authorImg) {
        this.authorImg = authorImg;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getVideoAddress() {
        return videoAddress;
    }

    public void setVideoAddress(String videoAddress) {
        this.videoAddress = videoAddress;
    }

    public Integer getKindId() {
        return kindId;
    }

    public void setKindId(Integer kindId) {
        this.kindId = kindId;
    }

    public Long getShares() {
        return shares;
    }

    public void setShares(Long shares) {
        this.shares = shares;
    }

    public Long getViews() {
        return views;
    }

    public void setViews(Long views) {
        this.views = views;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Date getIssueTime() {
        return issueTime;
    }

    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Byte getTop() {
        return top;
    }

    public void setTop(Byte top) {
        this.top = top;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Byte getChannel() {
        return channel;
    }

    public void setChannel(Byte channel) {
        this.channel = channel;
    }

    public Byte getHot() {
        return hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}