package com.bxm.localnews.quartz.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

public class RedisConfig {

    /**
     * 首页区域性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_AREA_LIST = DefaultKeyGenerator.build("news", "top");

    /**
     * 首页全国性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_WHOLE_COUNTRY_LIST = DefaultKeyGenerator.build("news", "top", "wholeCountry");

    /**
     * 小视频队列
     */
    public static KeyGenerator VIDEO_QUEUE = DefaultKeyGenerator.build("video", "queue");

    /**
     * 论坛帖子相关模块
     */
    public static KeyGenerator FORUM_RECOMMENDED = DefaultKeyGenerator.build("forum", "recommended");

    /**
     * 公司账户余额
     */
    public static KeyGenerator COMPANY_REMAIN_AMOUNT = DefaultKeyGenerator.build("payment", "company_remain_amount");

    /**
     * 蓝天救援队是否已助力完成
     */
    public static KeyGenerator BLUE_SKY_HELP_COMPLETE = DefaultKeyGenerator.build("activity", "blue_sky", "help_complete");
}
