package com.bxm.localnews.quartz.service;

import java.math.BigDecimal;

import com.bxm.localnews.quartz.vo.MoneyChange;

/**
 * @author zhaoyadong 2019/4/17 13:59
 * @desc 资金变动统计
 */
public interface MoneyChangeService {

    /**
     * 每小时统计统计一次金额变动
     * 1、微信账户对应的金额变动
     * 2、用户的赏金变动
     * 3、用户的变动
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return
     */
    MoneyChange changeMoneyStatisticsByHour(String startTime, String endTime);

    /**
     * 获取公司账户余额
     *
     * @return
     */
    BigDecimal getCompanyAccount();
}
