package com.bxm.localnews.quartz.service.impl;

import com.bxm.localnews.quartz.domain.MarketingActivitiesQuartzMapper;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.service.MarketingActivitiesQuartzService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketingActivitiesQuartzServiceImpl implements MarketingActivitiesQuartzService {

    private MarketingActivitiesQuartzMapper marketingActivitiesQuartzMapper;

    private NewsIntegrationService newsIntegrationService;

    @Autowired(required = false)
    public MarketingActivitiesQuartzServiceImpl(MarketingActivitiesQuartzMapper marketingActivitiesQuartzMapper,
                                                NewsIntegrationService newsIntegrationService) {
        this.marketingActivitiesQuartzMapper = marketingActivitiesQuartzMapper;
        this.newsIntegrationService = newsIntegrationService;
    }

    @Override
    public void publish() {
        newsIntegrationService.publishMarketingActivities();
    }
}
