package com.bxm.localnews.quartz.service.impl;

import com.bxm.localnews.quartz.constant.RedisConfig;
import com.bxm.localnews.quartz.domain.VideoMapper;
import com.bxm.localnews.quartz.domain.VideoViewMapper;
import com.bxm.localnews.quartz.service.VideoViewService;
import com.bxm.localnews.quartz.vo.Video;
import com.bxm.localnews.quartz.vo.VideoView;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoViewServiceImpl extends BaseService implements VideoViewService {

    @Autowired
    private RedisListAdapter redisListAdapter;

    @Autowired
    private VideoViewMapper videoViewMapper;

    @Autowired
    private VideoMapper videoMapper;

    @Override
    public void videoViewConsume() {
        KeyGenerator keyGenerator = RedisConfig.VIDEO_QUEUE.copy().setKey("videoViewQueue");
        VideoView videoView = redisListAdapter.rightPop(keyGenerator, VideoView.class);
        if (null != videoView) {

            videoView.setId(nextSequence());
            videoViewMapper.insertSelective(videoView);
            //更新新闻点击播放数
            Video video = videoMapper.selectByPrimaryKey(videoView.getVideoId());
            if (null != video) {
                Video videoUp = new Video();
                videoUp.setId(videoView.getVideoId());
                videoUp.setClickCount(video.getClickCount() + 1);
                videoMapper.updateByPrimaryKeySelective(videoUp);
            }
        }
    }
}
