package com.bxm.localnews.quartz.service.impl;

import java.util.List;

import com.bxm.localnews.quartz.domain.WithdrawMapper;
import com.bxm.localnews.quartz.integration.WithdrawIntegrationService;
import com.bxm.localnews.quartz.service.WithdrawFlowQuartzService;
import com.bxm.localnews.quartz.vo.WithdrawFlow;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/3/29 14:56
 * @desc
 */
@Service
@Slf4j
public class WithdrawFlowQuartzServiceImpl implements WithdrawFlowQuartzService {

    @Autowired
    private WithdrawMapper withdrawMapper;

    @Autowired
    private WithdrawIntegrationService withdrawIntegrationService;

    @Override
    public void queryWithdraw() {
        List<WithdrawFlow> withdrawFlowList = withdrawMapper.queryWithdraw();
        if (CollectionUtils.isNotEmpty(withdrawFlowList)) {
            withdrawFlowList.forEach(withdrawFlow -> {
                withdrawIntegrationService.queryWithdraw(withdrawFlow);
            });
        }
    }
}
