/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.service;

import com.bxm.localnews.quartz.service.PayFlowQuartzService;
import com.bxm.newidea.component.tools.DateUtils;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSplitTablePerMonthService
implements PayFlowQuartzService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSplitTablePerMonthService.class);
    private static final int CREATE_TABLE_MONTH_STEP = 1;
    private static final long AUTO_INCREMENT_STEP = 1000000000L;

    protected abstract String getDefaultTableName();

    protected abstract Map<String, Object> loadTableStatus(String var1);

    protected abstract void createTable(String var1, long var2);

    public String generateTableName() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        return this.getDefaultTableName() + "_" + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_WITHOUT_DAY_FORMAT.get()).format(calendar.getTime());
    }

    protected boolean existsTable(String tableName) {
        return this.loadTableStatus(tableName) != null;
    }

    private long getAutoIncrementNumber() {
        String currentTableName = this.generateTableName();
        Map<String, Object> currentTableStatus = this.loadTableStatus(currentTableName);
        if (currentTableStatus != null || !currentTableStatus.isEmpty()) {
            BigInteger currentIncrement = (BigInteger)currentTableStatus.get("Auto_increment");
            long multiple = currentIncrement.longValue() / 1000000000L;
            return ++multiple * 1000000000L;
        }
        return 1000000000L;
    }

    @Override
    public void createNextTable() {
        String nextTableName = this.generateTableName();
        long nextTableIncrement = this.getAutoIncrementNumber();
        if (!this.existsTable(nextTableName)) {
            this.createTable(nextTableName, nextTableIncrement);
            LOG.info("table :" + nextTableName + " create successfully!");
        } else {
            Map<String, Object> status = this.loadTableStatus(nextTableName);
            BigInteger autoIncrement = (BigInteger)status.get("Auto_increment");
            if (autoIncrement.longValue() < nextTableIncrement) {
                LOG.warn("table :" + nextTableName + " exists,but auto_increment not incorrect!");
                this.alterTableIncrement(nextTableName, nextTableIncrement);
                LOG.info("alter" + nextTableName + " auto_increment to " + nextTableIncrement + " successfully!");
            } else {
                LOG.info("table :" + nextTableName + " already exists!");
            }
        }
    }

    protected abstract void alterTableIncrement(String var1, long var2);
}

