/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.service.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.quartz.config.NewsProperties;
import com.bxm.localnews.quartz.domain.NewsPoolMapper;
import com.bxm.localnews.quartz.service.NewsPoolservice;
import com.bxm.localnews.quartz.vo.NewsPool;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class NewsPoolServiceImpl
extends BaseService
implements NewsPoolservice {
    private static final int MAX_POOL_SIZE = 5000;
    private static final int MAX_KIND_POOL_SIZE = 3000;
    @Autowired
    private NewsPoolMapper newsPoolMapper;
    @Autowired
    private NewsProperties newsProperties;

    @Override
    public void fillNewsPool() {
        List kindIds = this.newsPoolMapper.listKinds();
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(20);
        for (Integer kindId : kindIds) {
            fixedThreadPool.execute(() -> {
                int diff;
                HashMap<String, Integer> param = new HashMap<String, Integer>();
                param.put("kindId", kindId);
                param.put("isHot", 1);
                param.put("limit", 1000);
                List newsList = this.newsPoolMapper.recommendNews(param);
                int count = this.newsPoolMapper.getCount(param);
                if (count > 0 && (diff = newsList.size() + count - 3000) > 0) {
                    param.put("limit", diff);
                    this.newsPoolMapper.deleteExcess(param);
                }
                if (kindId.equals(this.newsProperties.getRecommendKindId())) {
                    newsList.addAll(this.fillRecommedNewsPool());
                    Collections.shuffle(newsList);
                }
                new BatchHelper<NewsPoolMapper, NewsPool>(NewsPoolMapper.class, (Collection)newsList){

                    protected int invoke(NewsPool element) {
                        return ((NewsPoolMapper)this.mapper).insert(element);
                    }
                };
            });
        }
        fixedThreadPool.shutdown();
        try {
            while (!fixedThreadPool.isTerminated()) {
                Thread.sleep(150L);
            }
        }
        catch (Exception e) {
            this.logger.error("an error occured in fixedThreadPool: {}", (Throwable)e);
        }
    }

    private List<NewsPool> fillRecommedNewsPool() {
        int diff;
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("isHot", 2);
        param.put("limit", 1000);
        List newsList = this.newsPoolMapper.recommendNews(param);
        ArrayList newsPoolList = Lists.newArrayList();
        int count = this.newsPoolMapper.getCount(param);
        if (count > 0 && (diff = count + newsList.size() - 5000) > 0) {
            param.put("limit", diff);
            this.newsPoolMapper.deleteExcess(param);
        }
        return newsPoolList;
    }
}

