/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.quartz.constant.NewsStatusEnum;
import com.bxm.localnews.quartz.domain.NewsQuartzMapper;
import com.bxm.localnews.quartz.facade.PushMsgIntegService;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.service.NewsQuartzService;
import com.bxm.localnews.quartz.vo.News;
import com.bxm.localnews.quartz.vo.NewsSearchWordBean;
import com.bxm.localnews.quartz.vo.RecommendNewsBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsQuartzServiceImpl
implements NewsQuartzService {
    private static final Logger logger = LoggerFactory.getLogger(NewsQuartzServiceImpl.class);
    private static String url = "http://top.baidu.com/buzz?b=1&fr=topindex";
    private static String userAgent = "User-Agent";
    private static String value = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36";
    private NewsQuartzMapper newsQuartzMapper;
    private PushMsgIntegService pushMsgIntegService;
    private NewsIntegrationService newsIntegrationService;

    @Autowired(required=false)
    public NewsQuartzServiceImpl(NewsQuartzMapper newsQuartzMapper, PushMsgIntegService pushMsgIntegService, NewsIntegrationService newsIntegrationService) {
        this.newsQuartzMapper = newsQuartzMapper;
        this.pushMsgIntegService = pushMsgIntegService;
        this.newsIntegrationService = newsIntegrationService;
    }

    private List<NewsSearchWordBean> loadHotword() {
        ArrayList<NewsSearchWordBean> list = new ArrayList<NewsSearchWordBean>();
        try {
            Document doc = Jsoup.connect((String)url).header(userAgent, value).timeout(5000).get();
            Elements elements = doc.select(".keyword");
            for (Element e : elements) {
                if (e == null) continue;
                Element ee = e.lastElementSibling();
                String name = e.select("a:eq(0)").text();
                String number = ee.select("span").text();
                NewsSearchWordBean word = new NewsSearchWordBean();
                word.setName(name);
                word.setNumber(Integer.valueOf(number));
                list.add(word);
                if (list.size() < 10) continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error("---\u6293\u53d6\u70ed\u70b9\u65b0\u95fb\u6807\u9898\u5f02\u5e38---");
        }
        return list;
    }

    @Override
    public void createHotword() {
        List<NewsSearchWordBean> searchWords = this.loadHotword();
        if (searchWords.size() > 8) {
            this.newsQuartzMapper.delete();
            this.newsQuartzMapper.insertBatch(searchWords);
        }
    }

    @Override
    public void execWakeup() {
        ArrayList newsList = new ArrayList();
        for (long i = 0L; i < 10L; ++i) {
            List newsBeanList = this.newsQuartzMapper.noticeRecommendNewsList(Long.valueOf(i));
            newsList.addAll(newsBeanList);
        }
        logger.info("\u63a8\u9001\u6d88\u606f\u7ed9\u7528\u6237\uff0c\u4e00\u5171{}\u4e2a\u7528\u6237", (Object)newsList.size());
        for (RecommendNewsBean news : newsList) {
            this.pushNews(news);
        }
    }

    private void pushNews(RecommendNewsBean news) {
        List imgs;
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.NEWS);
        info.addExtend("newsId", (Object)(news.getId() + ""));
        info.addExtend("title", (Object)news.getTitle());
        info.addExtend("isRecommendNews", (Object)2);
        info.addExtend("type", (Object)news.getType());
        if (!StringUtils.isEmpty((String)news.getImgUrl()) && (imgs = JSON.parseArray((String)news.getImgUrl(), String.class)).size() > 0) {
            info.addExtend("img", imgs.get(0));
        }
        PushMessage pushMessage = PushMessage.build().setPushReceiveScope(PushReceiveScope.pushSignle((Long)news.getUserId())).setPayloadInfo(info).setContent(news.getContent()).setTitle(news.getTitle());
        this.pushMsgIntegService.pushMsg(pushMessage);
    }

    @Override
    public void publish() {
        List list = this.newsQuartzMapper.listForPublish(NewsStatusEnum.UNPUBLISHED.getCode());
        for (News news : list) {
            this.newsQuartzMapper.updateStatusById(news.getId(), NewsStatusEnum.ENABLE.getCode());
        }
    }

    @Override
    public void hotExpire() {
        this.newsIntegrationService.checkHotNewsExpire();
    }

    @Override
    public void calcParticipantsNum() {
        this.newsIntegrationService.calcParticipantsNum();
    }
}

