/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.service.impl;

import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.quartz.domain.RedPacketMapper;
import com.bxm.localnews.quartz.facade.PushMsgIntegService;
import com.bxm.localnews.quartz.service.RedPacketQuartzService;
import com.bxm.localnews.quartz.vo.RedPacket;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedPacketQuartzServiceImpl
implements RedPacketQuartzService {
    private static final Logger LOG = LoggerFactory.getLogger(RedPacketQuartzServiceImpl.class);
    private RedPacketMapper redPacketMapper;
    private SequenceCreater sequenceCreater;
    private PushMsgIntegService pushMsgIntegService;

    @Autowired
    RedPacketQuartzServiceImpl(RedPacketMapper redPacketMapper, SequenceCreater sequenceCreater, PushMsgIntegService pushMsgIntegService) {
        this.redPacketMapper = redPacketMapper;
        this.sequenceCreater = sequenceCreater;
        this.pushMsgIntegService = pushMsgIntegService;
    }

    @Override
    public void pushMessage() {
        LOG.info("\u7ea2\u5305\u63a8\u9001\u670d\u52a1\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb");
        List pushRedPacketList = this.redPacketMapper.queryPushList();
        LOG.info("\u7ea2\u5305\u63a8\u9001\u670d\u52a1\u5b9a\u65f6\u4efb\u52a1\u6267\u884c,\u5f85\u63a8\u9001\u7684\u7ea2\u5305\u6570\u91cf\u4e3a:{}", (Object)pushRedPacketList.size());
        if (CollectionUtils.isEmpty((Collection)pushRedPacketList)) {
            LOG.info("\u5f85\u63a8\u9001\u7684\u7ea2\u5305\u5217\u8868\u4e3a\u7a7a");
            return;
        }
        pushRedPacketList.forEach(redPacket -> {
            this.pushMessageToClient((RedPacket)redPacket);
            this.redPacketMapper.updatePushFlag(redPacket.getId());
        });
    }

    private void pushMessageToClient(RedPacket redPacket) {
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.RECEIVE_RED_PACKET);
        String content = String.format("\ud83d\ude09\u54c7\u54e6\uff0c\u4f60\u7684\u7ea2\u5305\u5df2\u7ecf\u88ab%s\u4eba\u9886\u53d6\u4e86\uff0c\u770b\u770b\u90fd\u6709\u8c01", redPacket.getActualNum());
        Long msgId = this.sequenceCreater.nextLongId();
        info.setMsgId(msgId);
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("rpId", (Object)redPacket.getId());
        info.addExtend("userId", (Object)redPacket.getUserId());
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setTitle("");
        pushMessage.setContent(content);
        pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
        pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle((Long)redPacket.getUserId()));
        pushMessage.setPayloadInfo(info);
        this.pushMsgIntegService.pushMsg(pushMessage);
    }
}

