package com.bxm.localnews.quartz.runtime;

import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.quartz.constant.PushMessageStatusEnum;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.domain.AdminPushMessageMapper;
import com.bxm.localnews.quartz.facade.PushMsgIntegService;
import com.bxm.localnews.quartz.param.PushMsgBuildParam;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/1/17 10:07
 * @desc
 */
@Component
public class PushMessageTask extends AbstractRuntimeJob {

    @Autowired
    private AdminPushMessageMapper adminPushMessageMapper;

    @Autowired
    private PushMsgIntegService pushMsgIntegService;

    public PushMessageTask() {
        super("pushMessageTask", TaskGroup.ONCE);
        super.setCount(0);
    }

    @Override
    protected Message run() {
        logger.debug("定时推送开始执行:", JSON.toJSONString(this));
        Map<String, Object> paramMap = this.getParam();

        if (null != paramMap) {
            PushMsgBuildParam pushMsgBuildParam = (PushMsgBuildParam) paramMap.get("parameter");
            Long messageId = pushMsgBuildParam.getMessageId();
            PushMessage pushMessage = pushMsgBuildParam.getPushMessage();

            int status = adminPushMessageMapper.selectByPrimaryKey(messageId);

            if (PushMessageStatusEnum.STAY_CONFIRM.getType().equals(status)) {
                logger.warn("消息ID[{}]已取消推送", messageId);
                return Message.build(false).setMessage("消息ID[" + messageId + "]已取消推送");
            }
            if (PushMessageStatusEnum.BEING_SEND.getType().equals(status)) {
                logger.warn("消息ID[{}]正在推送中", messageId);
                return Message.build(false).setMessage("消息ID[" + messageId + "]正在推送中");
            }
            if (PushMessageStatusEnum.HAS_BEEN_SEND.getType().equals(status)) {
                return Message.build(false).setMessage("消息ID[" + messageId + "]已完成推送");
            }

            logger.debug("执行消息推送,推送消息ID:[{}],推送消息对象：[{}]", messageId, pushMessage);

            adminPushMessageMapper.updatePushMessageStatus(messageId, PushMessageStatusEnum.BEING_SEND.getType());
            pushMsgIntegService.pushMsg(pushMessage);

            return Message.build(true);
        }
        return Message.build(false).setMessage("消息推送任务调度失败，缺少参数注入");
    }
}
