package com.bxm.localnews.quartz.timer;

import com.bxm.localnews.quartz.domain.QuartzMapper;
import com.bxm.localnews.quartz.vo.QuartzLogBean;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.Map;

/**
 * 抽象的定时任务类
 * @author liujia 2018/8/3 10:07
 */
public abstract class AbstractTask extends AbstractCustomJob {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    private QuartzMapper quartzMapper;

    public AbstractTask(String jobName, String cron, String description) {
        super(jobName, cron, description);
    }

    public AbstractTask(String jobName, String group, String cron, String description) {
        super(jobName, group, cron, description);
    }

    public AbstractTask(String jobName, String group, String cron, String description, int priority, Map<String, Object> param) {
        super(jobName, group, cron, description, priority, param);
    }

    private QuartzMapper getQuartzMapper() {
        if (null == quartzMapper) {
            quartzMapper = SpringContextHolder.getBean(QuartzMapper.class);
        }
        return quartzMapper;
    }

    @Override
    protected void saveLog(Message errorMsg) {
        if (null != errorMsg) {
            QuartzLogBean log = new QuartzLogBean();
            log.setQuartzId(this.getJobName());
            log.setCreateTime(new Date());
            log.setResult("20");
            log.setResult(errorMsg.getLashMessaage());

            this.getQuartzMapper().insert(log);
        }
    }

}
