package com.bxm.localnews.quartz.timer;

import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.service.MarketingActivitiesQuartzService;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MarketingActivitiesQuartzTask extends AbstractTask {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private MarketingActivitiesQuartzService marketingActivitiesQuartzService;

    public MarketingActivitiesQuartzTask() {
        super("活动定时发布", TaskGroup.REFRESH, "0 0/5 * * * ?", "营销活动定时发布");
    }

    @Override
    protected Message service() {
        logger.debug(".....................................活动定时发布 begin.....................................");
        marketingActivitiesQuartzService.publish();
        logger.debug(".....................................活动定时发布 end.....................................");
        return Message.build(true);
    }
}
