package com.bxm.localnews.quartz.timer;

import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.service.NewsQuartzService;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsHotExpireTask extends AbstractTask  {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private NewsQuartzService newsQuartzService;

    public NewsHotExpireTask() {
        super("运营热标签设置过期失效", TaskGroup.CALCULATE, "0 0/5 * * * ? *", "每五分钟消费一次");
    }

    @Override
    protected Message service() {
        logger.info(".....................................运营热标签设置过期失效 begin.....................................");
        newsQuartzService.hotExpire();
        logger.info(".....................................运营热标签设置过期失效 end.....................................");
        return  Message.build(true);
    }
}
