/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.quartz.config.MessageUrlProperties;
import com.bxm.localnews.quartz.constant.RedisConfig;
import com.bxm.localnews.quartz.domain.HelpInfoMapper;
import com.bxm.localnews.quartz.facade.PushMsgIntegService;
import com.bxm.localnews.quartz.param.HelpRemindParam;
import com.bxm.localnews.quartz.runtime.AbstractRuntimeJob;
import com.bxm.localnews.quartz.vo.HelpUserInfo;
import com.bxm.newidea.component.quartz.service.ScheduleJobService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class HelpRemindTask
extends AbstractRuntimeJob {
    @Resource
    private HelpInfoMapper helpInfoMapper;
    @Resource
    private ScheduleJobService scheduleJobService;
    @Resource
    private PushMsgIntegService pushMsgIntegService;
    @Resource
    private MessageUrlProperties messageUrlProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;

    public HelpRemindTask() {
        super("helpRemindTask", "once");
        super.setCount(0);
    }

    @Override
    protected Message run() {
        this.logger.debug("\u84dd\u5929\u6551\u63f4\u961f\u5b9a\u65f6\u63d0\u9192\u4efb\u52a1\u5f00\u59cb\u6267\u884c:", (Object)JSON.toJSONString((Object)((Object)this)));
        Map paramMap = this.getParam();
        if (null != paramMap) {
            HelpRemindParam param = (HelpRemindParam)this.getParam().get("parameter");
            this.logger.info("\u84dd\u5929\u6551\u63f4\u961f\u5b9a\u65f6\u63d0\u9192\u4efb\u52a1\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            if (null == param || null == param.getEndTime()) {
                return Message.build((boolean)false).setMessage("\u53c2\u6570\u4e3a\u7a7a");
            }
            List userIdList = this.helpInfoMapper.getHelpUserIdList();
            Date endTime = DateUtils.parse((String)param.getEndTime());
            if (new Date().after(endTime)) {
                String title = "\u611f\u8c22\u4f60\u4e3a\u84dd\u5929\u6551\u63f4\u961f\u5949\u732e\u4e86\u4e00\u4efd\u7231\u5fc3\uff0c\u76ee\u524d\u6211\u4eec\u6b63\u5728\u4f20\u9012\u4f60\u7684\u7231\u5fc3\uff0c\u70b9\u51fb\u67e5\u770b";
                PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
                info.addExtend("url", (Object)this.messageUrlProperties.getPostDetail());
                PushMessage message = PushMessage.build();
                message.setTitle("\u901a\u77e5\u6d88\u606f");
                message.setContent(title);
                message.setType(TemplateTypeEnum.NOTIFCTION);
                message.setPushReceiveScope(PushReceiveScope.pushGroup((List)userIdList));
                message.setPayloadInfo(info);
                this.pushMsgIntegService.pushMsg(message);
                this.scheduleJobService.remove(this.getJobName(), this.getGroup());
                return Message.build((boolean)true);
            }
            if (this.redisStringAdapter.hasKey(RedisConfig.BLUE_SKY_HELP_COMPLETE.copy()).booleanValue()) {
                return Message.build((boolean)true);
            }
            Integer dayNum = DateUtils.getDiffDays((Date)new Date(), (Date)endTime, (boolean)true) + 1;
            String title = "\u8ddd\u79bb\u6d3b\u52a8\u7ed3\u675f\u8fd8\u6709" + dayNum + "\u5929\uff0c\u76ee\u524d\u7231\u5fc3\u52a9\u529b\u76ee\u6807\u8fd8\u672a\u8fbe\u6210\uff0c\u8bf7\u9080\u8bf7\u597d\u53cb\u518d\u52a9\u529b\u4e00\u6b21\u5427\uff01";
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
            PushMessage message = PushMessage.build();
            message.setTitle("\u901a\u77e5\u6d88\u606f");
            message.setContent(title);
            message.setType(TemplateTypeEnum.NOTIFCTION);
            if (CollectionUtils.isNotEmpty((Collection)userIdList)) {
                for (Long userId : userIdList) {
                    HelpUserInfo helpUserInfo = this.helpInfoMapper.getHelpUserInfo(userId);
                    info.addExtend("url", (Object)(this.messageUrlProperties.getBlueSkySharePage() + "?userId=" + userId + "&areaCode=" + helpUserInfo.getLocationCode() + "&areaName=" + helpUserInfo.getLocationName()));
                    message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
                    message.setPayloadInfo(info);
                    this.pushMsgIntegService.pushMsg(message);
                }
            }
            return Message.build((boolean)true);
        }
        return Message.build((boolean)false).setMessage("\u84dd\u5929\u6551\u63f4\u961f\u5b9a\u65f6\u63d0\u9192\u4efb\u52a1\u8c03\u5ea6\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u6ce8\u5165");
    }
}

