/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.quartz.constant.RedisConfig;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.param.PublishNewsBuildParam;
import com.bxm.localnews.quartz.runtime.AbstractRuntimeJob;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PublishNewsTask
extends AbstractRuntimeJob {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private NewsIntegrationService newsIntegrationService;

    public PublishNewsTask() {
        super("newsPublish", "once");
        super.setCount(0);
    }

    @Override
    protected Message run() {
        this.logger.debug("\u5b9a\u65f6\u65b0\u95fb\u53d1\u5e03\u5f00\u59cb\u6267\u884c:", (Object)JSON.toJSONString((Object)((Object)this)));
        Map paramMap = this.getParam();
        this.logger.debug(JSON.toJSONString((Object)paramMap));
        if (null != paramMap) {
            PublishNewsBuildParam param = (PublishNewsBuildParam)this.getParam().get("parameter");
            String areaCodes = param.getAreaCodes();
            Long newsId = param.getNewsId();
            this.newsIntegrationService.publishNews(newsId);
            this.clearRedisCacheOfTopNewsList(areaCodes);
            this.logger.info("id\u4e3a{}\u7684\u65b0\u95fb\u53d1\u5e03\u6210\u529f", (Object)newsId);
            return Message.build((boolean)true);
        }
        return Message.build((boolean)true);
    }

    private void clearRedisCacheOfTopNewsList(String areaCodeStr) {
        this.logger.info("\u6e05\u9664\u9996\u9875\u7f6e\u9876\u65b0\u95fb\u5217\u8868\u7f13\u5b58\u5f00\u59cb\u6267\u884c:");
        if (StringUtils.isNotEmpty((CharSequence)areaCodeStr)) {
            String[] areaCodes;
            for (String areaCode : areaCodes = areaCodeStr.split(",")) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey((Object)areaCode);
                this.redisStringAdapter.remove(keyGenerator);
            }
        } else {
            this.redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
        }
    }
}

