/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.quartz.constant.RedisConfig;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.param.UserTopPostBuildParam;
import com.bxm.localnews.quartz.runtime.AbstractRuntimeJob;
import com.bxm.localnews.quartz.vo.ForumTopPost;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.Message;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserTopPostTask
extends AbstractRuntimeJob {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private NewsIntegrationService newsIntegrationService;

    public UserTopPostTask() {
        super("userTopPostClean", "once");
        super.setCount(0);
    }

    @Override
    protected Message run() {
        this.logger.debug("\u5b9a\u65f6\u6e05\u7406\u7528\u6237\u5e16\u5b50\u7f6e\u9876\u5f00\u59cb\u6267\u884c:", (Object)JSON.toJSONString((Object)((Object)this)));
        Map paramMap = this.getParam();
        this.logger.debug(JSON.toJSONString((Object)paramMap));
        if (null != paramMap) {
            UserTopPostBuildParam param = (UserTopPostBuildParam)this.getParam().get("parameter");
            Long postId = param.getPostId();
            Long userId = param.getUserId();
            this.clearRedisCacheOfUserTopNewsList(userId);
            this.logger.info("id\u4e3a{}\u7684\u5e16\u5b50\u53d6\u6d88\u7528\u6237\u7f6e\u9876\u6210\u529f", (Object)postId);
            return Message.build((boolean)true);
        }
        return Message.build((boolean)true);
    }

    private void clearRedisCacheOfUserTopNewsList(Long userId) {
        KeyGenerator postUserTop = RedisConfig.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)"top");
        Long size = this.redisListAdapter.size(postUserTop);
        if (size == 0L) {
            return;
        }
        List forumTopPostList = this.redisListAdapter.leftIndex(postUserTop, size - 1L, ForumTopPost.class);
        this.logger.debug("[clearRedisCacheOfUserTopNewsList] \u5f97\u5230\u7528\u6237\u5728\u4e00\u4e2a\u5c0f\u65f6\u4ee5\u5185\u53d1\u7684\u5e16\u5b50:{}", (Object)JSONObject.toJSONString((Object)forumTopPostList));
        long currentTime = System.currentTimeMillis();
        forumTopPostList.removeIf(e -> currentTime - e.getAddTime().getTime() > 3300000L);
        this.redisListAdapter.remove(postUserTop);
        this.logger.debug("[clearRedisCacheOfUserTopNewsList] \u53d6\u6d88\u7528\u6237\u5728\u4e00\u4e2a\u5c0f\u65f6\u4ee5\u524d\u53d1\u7684\u5e16\u5b50\u7f6e\u9876:{}", (Object)JSONObject.toJSONString((Object)forumTopPostList));
        this.redisListAdapter.rightPush(postUserTop, (Object[])forumTopPostList.toArray(new ForumTopPost[0]));
    }
}

