package com.bxm.newidea.integration;

import com.bxm.newidea.param.NewsRecommended;
import com.bxm.newidea.service.NewsSyncFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class NewsSyncIntegrationService {

    @Autowired
    NewsSyncFeignService newsSyncFeignService;

    @Async
    public void generateRecommneded(Long userId, List<Long> newsIdList){
        List<NewsRecommended> newsRecommendedList = new ArrayList<>();
        for (Long id : newsIdList) {
            NewsRecommended newsRecommended = new NewsRecommended();
            newsRecommended.setUserId(userId);
            newsRecommended.setNewsId(id);
            newsRecommendedList.add(newsRecommended);
        }
        newsSyncFeignService.generateRecommeded(newsRecommendedList);
    }

}
