package com.bxm.newidea.recommend;

import com.bxm.newidea.recommend.handler.news.*;

import com.bxm.newidea.recommend.handler.video.EmergencyVideoRecommender;
import com.bxm.newidea.recommend.handler.video.OldMysqlVideoRecommender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
//TODO 配置方式优化
@Component
public  class RecommendManager {

    private EmergencyNewsRecommender emergencyNewsRecommender;

    private OldMysqlNewsRecommender oldMysqlNewsRecommender;

    private TopNewsRecommender topNewsRecommender;

    private OldMysqlVideoRecommender mysqlVideoRecommender;

    private EmergencyVideoRecommender emergencyVideoRecommender;

    private CollaborativeNewsRecommender collaborativeNewsRecommender;

    private LocalNewsRecommender localNewsRecommender;

    @Autowired
    public RecommendManager(EmergencyNewsRecommender emergencyNewsRecommender,
                            OldMysqlNewsRecommender oldMysqlNewsRecommender,
                            TopNewsRecommender topNewsRecommender,
                            OldMysqlVideoRecommender mysqlVideoRecommender,
                            EmergencyVideoRecommender emergencyVideoRecommender,
                            CollaborativeNewsRecommender collaborativeNewsRecommender,
                            LocalNewsRecommender localNewsRecommender) {
        this.emergencyNewsRecommender = emergencyNewsRecommender;
        this.oldMysqlNewsRecommender = oldMysqlNewsRecommender;
        this.topNewsRecommender = topNewsRecommender;
        this.mysqlVideoRecommender = mysqlVideoRecommender;
        this.emergencyVideoRecommender = emergencyVideoRecommender;
        this.collaborativeNewsRecommender = collaborativeNewsRecommender;
        this.localNewsRecommender = localNewsRecommender;
    }

    List<AbstractRecommender> getNewsRecommenders(){
        List<AbstractRecommender> list = new ArrayList<>();
        list.add(topNewsRecommender);
        list.add(localNewsRecommender);
        list.add(collaborativeNewsRecommender);
        list.add(oldMysqlNewsRecommender);
        list.add(emergencyNewsRecommender);
        return list;
    }

    List<AbstractRecommender> getVideoRecommenders(){
        List<AbstractRecommender> list = new ArrayList<>();
        list.add(mysqlVideoRecommender);
        list.add(emergencyVideoRecommender);
        return list;
    }
}
