package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 本地新闻策略
 */
@Component
public class LocalNewsRecommender extends AbstractNewsRecommender {

    private NewsMapper newsMapper;

    @Autowired(required = false)
    public LocalNewsRecommender(NewsMapper newsMapper,RedisListAdapter redisListAdapter, NewsRecommendedMapper newsRecommendedMapper) {
        super(0.1d, 2);
        this.newsMapper = newsMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsRecommendedMapper = newsRecommendedMapper;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        if(kindId==null&& StringUtils.isNotBlank(areaCode)) {
            List<Long> list = newsMapper.recommendLocalnews(userId, areaCode);
            return list;
        }
        return new ArrayList<>();
    }

    @Override
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {

    }
}
