package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.LocalNewsKindIdConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import com.bxm.newidea.vo.News;
import com.bxm.newidea.param.NewsRecommendParam;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnels;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 老版本mysql推荐策略
 */

@Component
public class OldMysqlNewsRecommender extends AbstractNewsRecommender {

    private NewsMapper newsMapper;


    @Autowired(required = false)
    public OldMysqlNewsRecommender(NewsRecommendedMapper newsRecommendedMapper, RedisListAdapter redisListAdapter, NewsMapper newsMapper) {
        super(0.8d, 4);
        this.newsRecommendedMapper = newsRecommendedMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsMapper = newsMapper;
    }


    @Override
    protected List<Long> syncRecommendNews(Long userId,Integer kindId, Integer num,String areaCode) {
        long begin = System.currentTimeMillis();
        KeyGenerator userCacheKey = RedisKeyConstant.NEWS_RECOMMEND.copy();
        if(kindId!=null){
            userCacheKey.setKey(String.valueOf(kindId));
        }
//        if(kindId!=null&&kindId.intValue()== LocalNewsKindIdConstant.LOCAL_NEWS){
//            userCacheKey.appendKey(areaCode);
//        }
        userCacheKey.appendKey(userId);
        long size = redisListAdapter.size(userCacheKey);
        if(size==0){
            //缓存池无内容则直接进行返回
            return new ArrayList<>();
        }
        //已经推荐过的新闻key
        KeyGenerator recommendedNewsKey = RedisKeyConstant.NEWS_RECOMMENDED.copy();
        recommendedNewsKey.appendKey(userId);
        long recommendedSize = redisListAdapter.size(recommendedNewsKey);
        List<Long> recommendedNewIds = redisListAdapter.leftIndex(recommendedNewsKey,recommendedSize-1,Long.class);
        //布隆过滤器去重 防止随着已经推荐过的记录膨胀 去重效率降低
        BloomFilter<Long> bloomFilter = null;
        if(recommendedNewIds!=null&&!recommendedNewIds.isEmpty()){
           bloomFilter = BloomFilter.create(Funnels.longFunnel(), recommendedNewIds.size(),0.0001);
           for(Long id:recommendedNewIds){
               bloomFilter.put(id);
           }
        }
        List<Long> resultList = new ArrayList<>();
        recommendedFilter(userCacheKey,num,bloomFilter,resultList);
        logger.debug("同步推荐耗时：{}",System.currentTimeMillis()-begin);
        return resultList;
    }



    @Override
    @Async
    protected void asyncRecommendNews(Long userId,Integer kindId,String areaCode) {
        long current = System.currentTimeMillis();
        NewsRecommendParam newsRecommendParam = new NewsRecommendParam();
        KeyGenerator userCacheKey = RedisKeyConstant.NEWS_RECOMMEND.copy();
        if(kindId!=null){
            userCacheKey.setKey(String.valueOf(kindId));
            newsRecommendParam.setKindId((long)kindId);
            //本地新闻
            if(kindId.intValue()== LocalNewsKindIdConstant.LOCAL_NEWS){
                userCacheKey.appendKey(areaCode);
                newsRecommendParam.setKindId(null);
                newsRecommendParam.setAreaCode(areaCode);
            }
        }
        userCacheKey.appendKey(userId);
        int size =  redisListAdapter.size(userCacheKey).intValue();
        if(size> NewsCacheThresholdConfig.ALARM_CACHE_SIZE){
            //缓存池内容尚无到达触发异步推荐的阀值 则暂不进行异步推荐
            return;
        }
        newsRecommendParam.setIsHot(1);
        newsRecommendParam.setUserId(userId);
        //补充满推荐缓存池
        newsRecommendParam.setPagesize(NewsCacheThresholdConfig.MAX_CACHE_SIZE);
        List<News> result = newsMapper.recommendNews(newsRecommendParam);
        News[] newsDtos = result.toArray(new News[0]);
        redisListAdapter.remove(userCacheKey);
        redisListAdapter.rightPush(userCacheKey, newsDtos);
        //保存1小时，考虑到很少用户会看1个小时以上的新闻，所以没必要存很长时间
        redisListAdapter.expire(userCacheKey, 3600);
        logger.info("给{}进行频道为{}的新闻推荐 结果结果：{}。花费时间{}", userId,kindId==null?"推荐":kindId, newsDtos.length,System.currentTimeMillis() - current);
    }


}
