package com.bxm.newidea.service.impl;

import com.bxm.newidea.constant.AppConstant;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.RecommendEngine;
import com.bxm.newidea.service.RecommendService;
import com.bxm.newidea.vo.News;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class RecommendServiceImpl implements RecommendService {

    private RecommendEngine recommendEngine;

    private NewsMapper newsMapper;

    @Autowired(required = false)
    public RecommendServiceImpl(NewsMapper newsMapper, RecommendEngine recommendEngine){
        this.newsMapper =newsMapper;
        this.recommendEngine = recommendEngine;
    }

    /**
     * 新闻推荐
     * @param userId 用户id
     * @param kindId 频道id 本地新闻时 频道id为-1
     * @param pageSize 本次获取新闻数量
     * @param areaCode 地区编码 参照国标 本地新闻时特有
     * @return 新闻列表
     */
    @Override
    public List<Long> recommend(Long userId, Integer kindId, Integer pageSize, String areaCode) {
        return recommendEngine.recommendNews(userId,kindId,pageSize,areaCode);
    }

    
    /**
     * 小视频推荐
     * @param userId 用户id
     * @param pageSize 本次获取小视频数量
     * @return 小视频列表
     */
    @Override
    public List<VideoDto> recommend(Long userId, Integer pageSize) {
        return recommendEngine.recommendVideo(userId,pageSize);
    }

    /**
     * 新闻详情页内容推荐
     * @param userId 用户id
     * @param newsId 新闻id
     * @return 新闻id集合
     */
    @Override
    public List<Long> recommendByNewsDetail(Long userId, Long newsId) {
        //调用存储过程，以及制定的篇数获取详情页推荐的文章
        List<News> list = newsMapper.queryRecommendNewsList(newsId, AppConstant.NEWS_DETAIL_RECOMMEND_NUM, userId==null?0:userId);
        List<Long> ids = new ArrayList<>();
        list.forEach(news -> ids.add(news.getId()));
        return ids;
    }
}
