package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import com.bxm.newidea.vo.News;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 置顶新闻推荐策略
 */
@Component
public class TopNewsRecommender  extends AbstractNewsRecommender {

    private NewsMapper newsMapper;

    @Autowired(required = false)
    public TopNewsRecommender(NewsMapper newsMapper, RedisListAdapter redisListAdapter, NewsRecommendedMapper newsRecommendedMapper) {
        super(0.3,0);
        this.newsMapper = newsMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsRecommendedMapper = newsRecommendedMapper;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num,String areaCode) {
        if(kindId!=null){
            //非推荐频道
            return new ArrayList<>();
        }
        List<News> newsList =newsMapper.getTops(num,areaCode);
        List<Long> ids = new ArrayList<>();
        newsList.forEach(news ->  ids.add(news.getId()) );
        recommended = false;
        return ids;
    }

    @Override
    protected void asyncRecommendNews(Long userId, Integer kindId,String areaCode) {

    }
}
