/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.NewsBlackMapper;
import com.bxm.newidea.domain.VideoBlackMapper;
import com.bxm.newidea.dto.VideoDto;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecommendFilter {
    private RedisListAdapter redisListAdapter;
    private BloomFilter<Long> globalNewsBlackFilter;
    private BloomFilter<Long> globalVideoBlackFilter;
    private NewsBlackMapper newsBlackMapper;
    private VideoBlackMapper videoBlackMapper;
    private KeyGenerator newsKeyGenerator = RedisKeyConstant.NEWS_BLACK.copy();
    private KeyGenerator videoKeyGenerator = RedisKeyConstant.VIDEO_BLACK.copy();

    @Autowired(required=false)
    public RecommendFilter(RedisListAdapter redisListAdapter, NewsBlackMapper newsBlackMapper, VideoBlackMapper videoBlackMapper) {
        this.redisListAdapter = redisListAdapter;
        this.newsBlackMapper = newsBlackMapper;
        this.videoBlackMapper = videoBlackMapper;
    }

    public List<Long> newsFilter(List<Long> ids) {
        long size = this.redisListAdapter.size(this.newsKeyGenerator);
        if (size == 0L || this.globalNewsBlackFilter == null) {
            this.refreshNewsBlackCache();
        }
        return ids.stream().filter(id -> !this.globalNewsBlackFilter.mightContain(id)).collect(Collectors.toList());
    }

    public void refreshNewsBlackCache() {
        List ids = this.newsBlackMapper.queryNewsBlackIdList();
        this.redisListAdapter.rightPush(this.newsKeyGenerator, (Object[])ids.toArray(new Long[0]));
        this.redisListAdapter.expire(this.newsKeyGenerator, 3600L);
        this.globalNewsBlackFilter = BloomFilter.create((Funnel)Funnels.longFunnel(), (int)ids.size(), (double)1.0E-4);
        ids.forEach(id -> this.globalNewsBlackFilter.put(id));
    }

    public List<VideoDto> videoFilter(List<VideoDto> ids) {
        long size = this.redisListAdapter.size(this.videoKeyGenerator);
        if (size == 0L || this.globalVideoBlackFilter == null) {
            this.refreshVideoBlackCache();
        }
        return ids.stream().filter(id -> !this.globalVideoBlackFilter.mightContain((Object)id.getId())).collect(Collectors.toList());
    }

    public void refreshVideoBlackCache() {
        List ids = this.videoBlackMapper.queryVideoBlackIdList();
        this.redisListAdapter.rightPush(this.videoKeyGenerator, (Object[])ids.toArray(new Long[0]));
        this.redisListAdapter.expire(this.videoKeyGenerator, 3600L);
        this.globalVideoBlackFilter = BloomFilter.create((Funnel)Funnels.longFunnel(), (int)ids.size(), (double)1.0E-4);
        ids.forEach(id -> this.globalVideoBlackFilter.put(id));
    }
}

