/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocalNewsRecommender
extends AbstractNewsRecommender {
    private NewsMapper newsMapper;
    private Integer localNewsSize = 5;

    @Autowired(required=false)
    public LocalNewsRecommender(NewsMapper newsMapper, RedisListAdapter redisListAdapter, NewsRecommendedMapper newsRecommendedMapper) {
        super(0.1, 2);
        this.newsMapper = newsMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsRecommendedMapper = newsRecommendedMapper;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        if (kindId == null && StringUtils.isNotBlank((String)areaCode)) {
            List list = this.newsMapper.recommendLocalnews(userId, areaCode);
            HashSet set = new HashSet(list);
            int size = list.size() > this.localNewsSize ? this.localNewsSize.intValue() : list.size();
            Iterator iterator = set.iterator();
            ArrayList<Long> resultList = new ArrayList<Long>();
            for (int i = 0; i < size; ++i) {
                resultList.add((Long)iterator.next());
            }
            return resultList;
        }
        return new ArrayList<Long>();
    }

    @Override
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {
    }
}

