/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.LocalNewsKindIdConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.param.NewsRecommendParam;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import com.bxm.newidea.vo.News;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OldMysqlNewsRecommender
extends AbstractNewsRecommender {
    private NewsMapper newsMapper;

    @Autowired(required=false)
    public OldMysqlNewsRecommender(NewsRecommendedMapper newsRecommendedMapper, RedisListAdapter redisListAdapter, NewsMapper newsMapper) {
        super(0.8, 4);
        this.newsRecommendedMapper = newsRecommendedMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsMapper = newsMapper;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        long begin = System.currentTimeMillis();
        KeyGenerator userCacheKey = RedisKeyConstant.NEWS_RECOMMEND.copy();
        if (kindId != null) {
            userCacheKey.setKey(String.valueOf(kindId));
        }
        userCacheKey.appendKey((Object)userId);
        long size = this.redisListAdapter.size(userCacheKey);
        if (size == 0L) {
            return new ArrayList<Long>();
        }
        KeyGenerator recommendedNewsKey = RedisKeyConstant.NEWS_RECOMMENDED.copy();
        recommendedNewsKey.appendKey((Object)userId);
        long recommendedSize = this.redisListAdapter.size(recommendedNewsKey);
        List recommendedNewIds = this.redisListAdapter.leftIndex(recommendedNewsKey, recommendedSize - 1L, Long.class);
        BloomFilter bloomFilter = null;
        if (recommendedNewIds != null && !recommendedNewIds.isEmpty()) {
            bloomFilter = BloomFilter.create((Funnel)Funnels.longFunnel(), (int)recommendedNewIds.size(), (double)1.0E-4);
            for (Long id : recommendedNewIds) {
                bloomFilter.put((Object)id);
            }
        }
        ArrayList<Long> resultList = new ArrayList<Long>();
        this.recommendedFilter(userCacheKey, num, (BloomFilter<Long>)bloomFilter, resultList);
        this.logger.debug("\u540c\u6b65\u63a8\u8350\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        return resultList;
    }

    @Override
    @Async
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {
        long current = System.currentTimeMillis();
        NewsRecommendParam newsRecommendParam = new NewsRecommendParam();
        KeyGenerator userCacheKey = RedisKeyConstant.NEWS_RECOMMEND.copy();
        if (kindId != null) {
            userCacheKey.setKey(String.valueOf(kindId));
            newsRecommendParam.setKindId(Long.valueOf(kindId.intValue()));
            if (kindId.intValue() == LocalNewsKindIdConstant.LOCAL_NEWS.intValue()) {
                userCacheKey.appendKey((Object)areaCode);
                newsRecommendParam.setKindId(null);
                newsRecommendParam.setAreaCode(areaCode);
            }
        }
        userCacheKey.appendKey((Object)userId);
        int size = this.redisListAdapter.size(userCacheKey).intValue();
        if (size > NewsCacheThresholdConfig.ALARM_CACHE_SIZE) {
            return;
        }
        newsRecommendParam.setIsHot(Integer.valueOf(1));
        newsRecommendParam.setUserId(userId);
        newsRecommendParam.setPagesize(Integer.valueOf(NewsCacheThresholdConfig.MAX_CACHE_SIZE));
        List result = this.newsMapper.recommendNews(newsRecommendParam);
        Object[] newsDtos = result.toArray(new News[0]);
        this.redisListAdapter.remove(userCacheKey);
        this.redisListAdapter.rightPush(userCacheKey, newsDtos);
        this.redisListAdapter.expire(userCacheKey, 3600L);
        this.logger.info("\u7ed9{}\u8fdb\u884c\u9891\u9053\u4e3a{}\u7684\u65b0\u95fb\u63a8\u8350 \u7ed3\u679c\u7ed3\u679c\uff1a{}\u3002\u82b1\u8d39\u65f6\u95f4{}", new Object[]{userId, kindId == null ? "\u63a8\u8350" : kindId, newsDtos.length, System.currentTimeMillis() - current});
    }
}

