/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.service.impl;

import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.RecommendEngine;
import com.bxm.newidea.service.RecommendService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecommendServiceImpl
implements RecommendService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RecommendEngine recommendEngine;
    private NewsMapper newsMapper;

    @Autowired(required=false)
    public RecommendServiceImpl(NewsMapper newsMapper, RecommendEngine recommendEngine) {
        this.newsMapper = newsMapper;
        this.recommendEngine = recommendEngine;
    }

    @Override
    public List<Long> recommend(Long userId, Integer kindId, Integer pageSize, String areaCode) {
        return this.recommendEngine.recommendNews(userId, kindId, pageSize, areaCode);
    }

    @Override
    public List<VideoDto> recommend(Long userId, Integer pageSize) {
        this.logger.info("Video recommend->userId:{},pageSize:{}", (Object)userId, (Object)pageSize);
        return this.recommendEngine.recommendVideo(userId, pageSize);
    }

    @Override
    public List<Long> recommendByNewsDetail(Long userId, Long newsId) {
        List list = this.newsMapper.queryRecommendNewsList(newsId, 5, Long.valueOf(userId == null ? 0L : userId));
        ArrayList<Long> ids = new ArrayList<Long>();
        list.forEach(news -> ids.add(news.getId()));
        return ids;
    }
}

