/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend;

import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.recommend.handler.mix.FixMixRecommender;
import com.bxm.newidea.recommend.handler.mix.RecentlyMixRecommender;
import com.bxm.newidea.recommend.handler.news.EmergencyNewsRecommender;
import com.bxm.newidea.recommend.handler.news.HotNewsRecommender;
import com.bxm.newidea.recommend.handler.news.LocalNewsRecommender;
import com.bxm.newidea.recommend.handler.news.OldMysqlNewsRecommender;
import com.bxm.newidea.recommend.handler.news.OldMysqlRecNewsRecommender;
import com.bxm.newidea.recommend.handler.video.EmergencyVideoRecommender;
import com.bxm.newidea.recommend.handler.video.OldMysqlVideoRecommender;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class RecommendManager
implements ApplicationContextAware,
InitializingBean {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private EmergencyNewsRecommender emergencyNewsRecommender;
    private OldMysqlNewsRecommender oldMysqlNewsRecommender;
    private OldMysqlVideoRecommender mysqlVideoRecommender;
    private EmergencyVideoRecommender emergencyVideoRecommender;
    private LocalNewsRecommender localNewsRecommender;
    private HotNewsRecommender hotNewsRecommender;
    private OldMysqlRecNewsRecommender oldMysqlRecNewsRecommender;
    private FixMixRecommender fixMixRecommender;
    private RecentlyMixRecommender recentlyMixRecommender;
    private ApplicationContext applicationContext;
    private Map<String, AbstractRecommender> allRecommender;
    private static Map<Integer, String> operationRecommenderMap = new ConcurrentHashMap<Integer, String>();

    @Autowired
    public RecommendManager(EmergencyNewsRecommender emergencyNewsRecommender, OldMysqlNewsRecommender oldMysqlNewsRecommender, OldMysqlVideoRecommender mysqlVideoRecommender, EmergencyVideoRecommender emergencyVideoRecommender, LocalNewsRecommender localNewsRecommender, HotNewsRecommender hotNewsRecommender, OldMysqlRecNewsRecommender oldMysqlRecNewsRecommender, FixMixRecommender fixMixRecommender, RecentlyMixRecommender recentlyMixRecommender) {
        this.emergencyNewsRecommender = emergencyNewsRecommender;
        this.oldMysqlNewsRecommender = oldMysqlNewsRecommender;
        this.mysqlVideoRecommender = mysqlVideoRecommender;
        this.emergencyVideoRecommender = emergencyVideoRecommender;
        this.localNewsRecommender = localNewsRecommender;
        this.hotNewsRecommender = hotNewsRecommender;
        this.oldMysqlRecNewsRecommender = oldMysqlRecNewsRecommender;
        this.fixMixRecommender = fixMixRecommender;
        this.recentlyMixRecommender = recentlyMixRecommender;
    }

    public List<AbstractRecommender> getNewsRecommenders() {
        ArrayList<AbstractRecommender> list = new ArrayList<AbstractRecommender>();
        list.add(this.oldMysqlNewsRecommender);
        list.add(this.emergencyNewsRecommender);
        return list;
    }

    public List<AbstractRecommender> getVideoRecommenders() {
        ArrayList<AbstractRecommender> list = new ArrayList<AbstractRecommender>();
        list.add(this.mysqlVideoRecommender);
        list.add(this.emergencyVideoRecommender);
        return list;
    }

    public List<AbstractRecommender> getCommonNewsRecommenders() {
        ArrayList<AbstractRecommender> list = new ArrayList<AbstractRecommender>();
        list.add(this.oldMysqlRecNewsRecommender);
        list.add(this.emergencyNewsRecommender);
        return list;
    }

    public List<AbstractRecommender> getMixRecommenders() {
        ArrayList<AbstractRecommender> list = new ArrayList<AbstractRecommender>();
        list.add(this.recentlyMixRecommender);
        list.add(this.fixMixRecommender);
        return list;
    }

    public AbstractRecommender getLocalNewsRecommender() {
        return this.localNewsRecommender;
    }

    public AbstractRecommender getHotNewsRecommender() {
        return this.hotNewsRecommender;
    }

    public AbstractRecommender getForumRecommender(ForumParam forumParam) {
        String recommenderName = operationRecommenderMap.get(forumParam.getOperationId());
        if (StringUtils.isBlank((CharSequence)recommenderName)) {
            this.logger.error("specified recommendable does not exist,operationId {},userId {},areacode:{}", new Object[]{forumParam.getOperationId(), forumParam.getUserId(), forumParam.getAreaCode()});
            return null;
        }
        return this.allRecommender.get(recommenderName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.allRecommender = this.applicationContext.getBeansOfType(AbstractRecommender.class);
    }

    static {
        operationRecommenderMap.put(OperationLocationEnum.FORUM_HOME_PAGE.getCode(), "forumCommonRecommender");
        operationRecommenderMap.put(OperationLocationEnum.FORUM_PLATE_ELITE.getCode(), "forumCommonRecommender");
        operationRecommenderMap.put(OperationLocationEnum.FORUM_PLATE_NEWEST.getCode(), "forumCommonRecommender");
        operationRecommenderMap.put(OperationLocationEnum.FORUM_TOPIC_NEWEST.getCode(), "forumCommonRecommender");
        operationRecommenderMap.put(OperationLocationEnum.FORUM_TOPIC_HOT.getCode(), "forumTopicHotRecommender");
        operationRecommenderMap.put(OperationLocationEnum.FORUM_POST_DETAIL.getCode(), "forumDetailRecommender");
    }
}

