/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.engine;

import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.recommend.RecommendManager;
import com.bxm.newidea.recommend.filter.RecommendFilter;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoRecommendEngine {
    private Logger logger = LoggerFactory.getLogger(VideoRecommendEngine.class);
    private RecommendFilter recommendFilter;
    private RecommendManager recommendManager;

    @Autowired
    public VideoRecommendEngine(RecommendManager recommendManager, RecommendFilter recommendFilter) {
        this.recommendManager = recommendManager;
        this.recommendFilter = recommendFilter;
    }

    public List<VideoDto> recommendVideo(Long userId, Integer num) {
        List<AbstractRecommender> recommenderWorkers = this.recommendManager.getVideoRecommenders();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();
        this.logger.debug("\u89c6\u9891\u65b0\u95fb\u63a8\u8350\u5f15\u64ce\u8c03\u7528\u94fe\uff1a{}", recommenderWorkers);
        List<VideoDto> videoDtoList = new LinkedList<VideoDto>();
        int differenceNum = 0;
        while (iterator.hasNext()) {
            AbstractRecommender recommender = iterator.next();
            int fetchNum = new BigDecimal(num).multiply(new BigDecimal(recommender.getWeight())).intValue() + differenceNum;
            List<VideoDto> results = recommender.recommend(userId, fetchNum);
            this.logger.debug("\u63a8\u8350\u5668\uff1a{} \u63a8\u8350\u7ed3\u679c\uff1a{}", ((Object)((Object)recommender)).getClass(), (Object)results.size());
            differenceNum = fetchNum - results.size();
            videoDtoList.addAll(results);
            if (videoDtoList.size() != num.intValue()) continue;
            break;
        }
        videoDtoList = this.recommendFilter.videoFilter(videoDtoList);
        return (videoDtoList = this.removeDuplicateVideo(videoDtoList)).size() > num ? videoDtoList.subList(0, num) : videoDtoList;
    }

    private List<VideoDto> removeDuplicateVideo(List<VideoDto> list) {
        HashSet<VideoDto> h = new HashSet<VideoDto>(list);
        list.clear();
        list.addAll(h);
        return list;
    }
}

