/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.framework;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.param.NewsRecommendParam;
import com.bxm.newidea.recommend.AbstractRecommender;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractNewsRecommender
extends AbstractRecommender {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected RedisListAdapter redisListAdapter;
    protected NewsSyncIntegrationService newsSyncIntegrationService;
    @Autowired
    protected RedisSetAdapter redisSetAdapter;

    public AbstractNewsRecommender(double weight, int sort) {
        super(weight, sort);
    }

    @Override
    public List<Long> recommend(NewsRecommendParam param) {
        long begin = System.currentTimeMillis();
        int num = param.getNum();
        Long userId = param.getUserId();
        String areaCode = param.getAreaCode();
        Integer kindId = param.getKindId();
        List<Long> ids = this.syncRecommend(userId, kindId, num, areaCode);
        this.asyncProcessing(userId, ids);
        AbstractNewsRecommender recommender = (AbstractNewsRecommender)((Object)SpringContextHolder.getBean(((Object)((Object)this)).getClass()));
        recommender.asyncRecommend(userId, kindId, areaCode);
        this.logger.info("{}\u63a8\u8350\u5668\u63a8\u8350\u7ed3\u679c:{}, \u53c2\u6570:{}, \u8017\u65f6:{}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), ids == null ? Integer.valueOf(0) : JSONObject.toJSONString(ids), JSONObject.toJSON((Object)param), System.currentTimeMillis() - begin});
        return ids;
    }

    protected abstract List<Long> syncRecommend(Long var1, Integer var2, Integer var3, String var4);

    protected abstract void asyncRecommend(Long var1, Integer var2, String var3);

    private void asyncProcessing(Long userId, List<Long> ids) {
        if (ids != null && !ids.isEmpty()) {
            KeyGenerator recommendedNewsKey = RedisKeyConstant.NEWS_NEW_RECOMMENDED.copy().appendKey((Object)userId);
            this.redisSetAdapter.add(recommendedNewsKey, (Object[])ids.toArray(new Long[0]));
            this.redisSetAdapter.expire(recommendedNewsKey, (long)NewsCacheThresholdConfig.NEWS_EXPIRE_RECOMMENDED_RECORD);
        }
    }

    protected void recommendedFilter(KeyGenerator newsPoolKey, Integer num, List<Long> resultList, Long userId) {
        long begin = System.currentTimeMillis();
        long total = this.redisListAdapter.size(newsPoolKey);
        if (0L == total) {
            return;
        }
        List newsList = this.redisListAdapter.leftIndex(newsPoolKey, total, Long.class);
        this.logger.debug("redis\u62c9\u53d6\u5217\u8868\u8017\u65f6\uff1a{} \u5217\u8868\u957f\uff1a{}", (Object)(System.currentTimeMillis() - begin), (Object)newsList.size());
        KeyGenerator recommendedNewsKey = RedisKeyConstant.NEWS_NEW_RECOMMENDED.copy().appendKey((Object)userId);
        Set record = this.redisSetAdapter.getAllMembers(recommendedNewsKey, Long.class);
        ArrayList<Long> repeatNewsList = new ArrayList<Long>();
        int i = 0;
        for (Long id : newsList) {
            this.generateResult(record, id, resultList, repeatNewsList);
            ++i;
            if (resultList.size() < num) continue;
            this.logger.info("[recommendedFilter][redis\u7f13\u5b58\u6c60]{}\u63a8\u8350\u5668\u7ecf\u53bb\u91cd\u540e\u5df2\u53d6\u5f97{}\u6761\u65b0\u95fb\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)num);
            break;
        }
        this.redisListAdapter.leftTrim(newsPoolKey, (long)i, total);
        if (repeatNewsList.size() > 0) {
            this.logger.debug("[recommendedFilter][redis\u7f13\u5b58\u6c60]\u5e03\u9686\u8fc7\u6ee4\u5668\u7b5b\u9009\u5df2\u91cd\u590d,\u8865\u5f55\u63a8\u8350\u91cd\u590d\u65b0\u95fb\uff1a{}", (Object)JSON.toJSONString(repeatNewsList));
            this.newsSyncIntegrationService.generateRecommneded(userId, repeatNewsList);
        }
        this.logger.debug("[recommendedFilter][redis\u7f13\u5b58\u6c60]bloom\u53bb\u91cd\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
    }

    protected void recommendedFilter(List<Long> originList, Integer num, List<Long> resultList, Long userId) {
        long begin = System.currentTimeMillis();
        KeyGenerator recommendedNewsKey = RedisKeyConstant.NEWS_NEW_RECOMMENDED.copy().appendKey((Object)userId);
        Set record = this.redisSetAdapter.getAllMembers(recommendedNewsKey, Long.class);
        ArrayList<Long> repeatNewsList = new ArrayList<Long>();
        for (Long id : originList) {
            this.generateResult(record, id, resultList, repeatNewsList);
            if (resultList.size() < num) continue;
            this.logger.info("[recommendedFilter][db\u6570\u636e\u5e93]{}\u63a8\u8350\u5668\u7ecf\u53bb\u91cd\u540e\u5df2\u53d6\u5f97{}\u6761\u65b0\u95fb\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", ((Object)((Object)this)).getClass(), (Object)num);
            break;
        }
        if (repeatNewsList.size() > 0) {
            this.logger.debug("[recommendedFilter][db\u6570\u636e\u5e93]\u5e03\u9686\u8fc7\u6ee4\u5668\u7b5b\u9009\u5df2\u91cd\u590d,\u63a8\u8350\u91cd\u590d\u65b0\u95fb\uff1a{}", (Object)JSON.toJSONString(repeatNewsList));
            this.newsSyncIntegrationService.generateRecommneded(userId, repeatNewsList);
        }
        this.logger.debug("[recommendedFilter][db\u6570\u636e\u5e93]\u666e\u901a\u53bb\u91cd\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
    }

    private void generateResult(Set<Long> record, Long id, List<Long> resultList, List<Long> repeatList) {
        if (!record.contains(id)) {
            resultList.add(id);
            record.add(id);
        } else {
            repeatList.add(id);
        }
    }
}

