/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.framework;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.VideoRecommendMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.AbstractRecommender;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractVideoRecommender
extends AbstractRecommender {
    protected RedisListAdapter redisListAdapter;
    protected VideoRecommendMapper videoRecommendMapper;

    public AbstractVideoRecommender(double weight, int sort) {
        super(weight, sort);
    }

    @Override
    public List<VideoDto> recommend(Long userId, Integer num) {
        List<VideoDto> videoDtos = this.syncRecommend(userId, num);
        if (videoDtos != null && !videoDtos.isEmpty()) {
            ArrayList ids = new ArrayList();
            videoDtos.forEach(videoDto -> ids.add(videoDto.getId()));
            KeyGenerator recommendedNewsKey = RedisKeyConstant.VIDEO_RECOMMENDED.copy().appendKey((Object)userId);
            this.redisListAdapter.rightPush(recommendedNewsKey, (Object[])ids.toArray(new Long[0]));
            this.videoRecommendMapper.batchInsert(userId, ids);
        }
        AbstractVideoRecommender recommender = (AbstractVideoRecommender)((Object)SpringContextHolder.getBean(((Object)((Object)this)).getClass()));
        recommender.asyncRecommend(userId);
        return videoDtos;
    }

    protected abstract List<VideoDto> syncRecommend(Long var1, Integer var2);

    protected abstract void asyncRecommend(Long var1);
}

