/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.param.ForumQueryParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.util.ObjectUtil;
import com.bxm.newidea.vo.ForumTopPost;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ForumCommonRecommender
extends AbstractForumRecommender {
    private static final Logger LOG = LoggerFactory.getLogger(ForumCommonRecommender.class);
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private RedisListAdapter redisListAdapter;

    public ForumCommonRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        ForumQueryParam param;
        List forumPostList;
        Long userId = forumParam.getUserId();
        Integer operationId = forumParam.getOperationId();
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"already");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"last");
        KeyGenerator postUserTopKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)"top");
        HashSet<Long> postUserTopIds = new HashSet<Long>();
        ArrayList result = Lists.newArrayList();
        Set recommendedIds = null;
        String lastRecommendedTime = "";
        if (null == forumParam.getActionType() || 1 == forumParam.getActionType()) {
            this.redisStringAdapter.remove(recommendedKey);
            this.redisStringAdapter.remove(lastRecommendedKey);
            this.getUserTopPost(forumParam, postUserTopIds, result, postUserTopKey);
        } else {
            recommendedIds = this.redisSetAdapter.getAllMembers(recommendedKey, Long.class);
            lastRecommendedTime = this.redisStringAdapter.getString(lastRecommendedKey);
        }
        if (null == recommendedIds) {
            recommendedIds = Sets.newHashSet();
        }
        if (CollectionUtils.isNotEmpty(postUserTopIds)) {
            recommendedIds.addAll(postUserTopIds);
        }
        Integer isBrilliant = null;
        if (OperationLocationEnum.FORUM_PLATE_ELITE.getCode() == forumParam.getOperationId().intValue()) {
            isBrilliant = 1;
        }
        if (StringUtils.isNotBlank((CharSequence)(lastRecommendedTime = this.findMoreForumPost(result, forumPostList = this.forumPostMapper.findForumPostList(param = this.getQueryParam(forumParam, lastRecommendedTime, isBrilliant, null)), recommendedIds, param, 0)))) {
            this.redisStringAdapter.set(lastRecommendedKey, (Object)lastRecommendedTime);
        }
        if (null != result && result.size() != 0) {
            Long[] idsArray = new Long[result.size()];
            this.redisSetAdapter.add(recommendedKey, (Object[])result.toArray(idsArray));
        }
        return result;
    }

    private void getUserTopPost(ForumParam forumParam, Set<Long> postUserTopIds, List<Long> result, KeyGenerator postUserTopKey) {
        Long size = this.redisListAdapter.size(postUserTopKey);
        if (size > 0L) {
            List forumTopPostList = this.redisListAdapter.leftIndex(postUserTopKey, size - 1L, ForumTopPost.class).stream().filter(e -> e.getAreaCode().equals(forumParam.getAreaCode())).sorted(Comparator.comparing(ForumTopPost::getDisplayTime).reversed()).collect(Collectors.toList());
            if (forumParam.getOperationId() == 5) {
                if (CollectionUtils.isNotEmpty(forumTopPostList = forumTopPostList.stream().filter(e -> Objects.nonNull(e) && null != e.getForumId() && e.getForumId().equals(forumParam.getForumId())).collect(Collectors.toList()))) {
                    List ids = forumTopPostList.stream().map(ForumTopPost::getId).collect(Collectors.toList());
                    forumParam.setPageSize(Integer.valueOf(forumParam.getPageSize() - forumTopPostList.size()));
                    postUserTopIds.addAll(ids);
                    result.addAll(ids);
                }
            } else if (forumParam.getOperationId() == 3) {
                ArrayList ids = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty(forumTopPostList)) {
                    block0: for (ForumTopPost e2 : forumTopPostList) {
                        List topicIds = e2.getTopicIds();
                        if (CollectionUtils.isEmpty((Collection)topicIds)) continue;
                        for (Long topicId : topicIds) {
                            if (NumberUtils.compare((long)topicId, (long)forumParam.getTopicId()) != 0) continue;
                            ids.add(e2.getId());
                            continue block0;
                        }
                    }
                    forumParam.setPageSize(Integer.valueOf(forumParam.getPageSize() - forumTopPostList.size()));
                    postUserTopIds.addAll(ids);
                    result.addAll(ids);
                }
            } else if (forumParam.getOperationId() == 2 && CollectionUtils.isNotEmpty(forumTopPostList)) {
                List ids = forumTopPostList.stream().map(ForumTopPost::getId).collect(Collectors.toList());
                forumParam.setPageSize(Integer.valueOf(forumParam.getPageSize() - forumTopPostList.size()));
                postUserTopIds.addAll(ids);
                result.addAll(ids);
            }
        }
    }

    private String findMoreForumPost(List<Long> result, List<Map<String, Object>> forumPostList, Set<Long> recommendedIds, ForumQueryParam param, int count) {
        if (null == forumPostList || forumPostList.size() == 0 || 5 == count) {
            LOG.warn("[forum plate elite]post is none");
            return "";
        }
        int postSize = forumPostList.size();
        String lastRecommendedTime = param.getLastTime();
        boolean hasMore = true;
        for (int j = 0; j < postSize; ++j) {
            Long id = ObjectUtil.displayToLong(forumPostList.get(j).get("id"));
            if (null != id && !recommendedIds.contains(id)) {
                if (!result.contains(id)) {
                    result.add(id);
                } else if (j == postSize - 1) {
                    hasMore = false;
                }
                if (result.size() >= param.getSize()) {
                    return ObjectUtil.displayToString(((Map)forumPostList.get(j)).get("display_time"));
                }
            }
            lastRecommendedTime = j == postSize - 1 && !hasMore ? null : ObjectUtil.displayToString(((Map)forumPostList.get(j)).get("display_time"));
        }
        if (result.size() < param.getSize()) {
            if (StringUtils.isBlank((CharSequence)lastRecommendedTime)) {
                return param.getLastTime();
            }
            param.setLastTime(lastRecommendedTime);
            forumPostList = this.forumPostMapper.findForumPostList(param);
            return this.findMoreForumPost(result, forumPostList, recommendedIds, param, ++count);
        }
        return lastRecommendedTime;
    }

    private ForumQueryParam getQueryParam(ForumParam forumParam, String lastRecommendedTime, Integer isBrilliant, Integer deadline) {
        ForumQueryParam param = new ForumQueryParam();
        param.setAreaCode(forumParam.getAreaCode());
        param.setBrilliant(isBrilliant);
        param.setDeadline(deadline);
        param.setForumId(forumParam.getForumId());
        param.setLastTime(lastRecommendedTime);
        param.setTopicId(forumParam.getTopicId());
        param.setSize(forumParam.getPageSize());
        return param;
    }
}

