/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.domain.LocalnewsRecommendedMapper;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.util.ObjectUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ForumDetailRecommender
extends AbstractForumRecommender {
    private static final Logger LOG = LoggerFactory.getLogger(ForumDetailRecommender.class);
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private LocalnewsRecommendedMapper localNewsMapper;

    public ForumDetailRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        ArrayList result = Lists.newArrayList();
        if (null == forumParam.getPostId()) {
            LOG.warn("[forum detail] post_id is null");
            return result;
        }
        Long province = Long.valueOf(forumParam.getAreaCode().substring(0, 2));
        int newsNum = null == forumParam.getNewsNum() ? 2 : forumParam.getNewsNum();
        List newsList = this.localNewsMapper.findNewsByForumTag(forumParam.getAreaCode(), forumParam.getPostId(), province, forumParam.getUserId(), Integer.valueOf(newsNum));
        if (CollectionUtils.isEmpty((Collection)newsList)) {
            LOG.warn("[forum detail] news is null,post_id is {}", (Object)forumParam.getPostId());
        } else {
            for (Map forum : newsList) {
                Object id = forum.get("id");
                if (null == id) continue;
                result.add((Long)id);
            }
        }
        int postNum = null == forumParam.getPostNum() ? 3 : forumParam.getPostNum();
        List forumList = this.forumPostMapper.findForumPostByTag(forumParam.getPostId(), postNum, forumParam.getAreaCode());
        if (CollectionUtils.isEmpty((Collection)forumList)) {
            LOG.warn("[forum detail] the tag post is null,post_id is {}", (Object)forumParam.getPostId());
            return result;
        }
        for (Map forum : forumList) {
            Object postId = forum.get("id");
            if (null == postId) continue;
            result.add(ObjectUtil.displayToLong(postId));
        }
        return result;
    }
}

