/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.mix;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.recommend.framework.AbstractMixRecommender;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RecentlyMixRecommender
extends AbstractMixRecommender {
    @Autowired(required=false)
    public RecentlyMixRecommender(RedisSetAdapter redisSetAdapter, RedisListAdapter redisListAdapter, RedisStringAdapter redisStringAdapter, MixedRecommendPoolMapper mixedRecommendPoolMapper) {
        super(1.0, 1);
        this.redisSetAdapter = redisSetAdapter;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
    }

    @Override
    protected List<MixRecomendResult> syncRecommend(Long userId, Integer actionType, Integer num, String areaCode) {
        long begin = System.currentTimeMillis();
        if (2 == actionType) {
            return new ArrayList<MixRecomendResult>();
        }
        KeyGenerator mixRecordKey = RedisKeyConstant.MIX_RECOMMENDED.copy().appendKey((Object)userId);
        KeyGenerator mixRecentlyPoolKey = RedisKeyConstant.MIX_RECENTLY_POOL.copy().appendKey((Object)userId);
        KeyGenerator lastReadTimeKey = RedisKeyConstant.MIX_LAST_READ_TIME.copy().appendKey((Object)userId);
        ArrayList<MixRecomendResult> resultList = new ArrayList<MixRecomendResult>();
        this.redisSetAdapter.remove(mixRecordKey);
        Date lastReadTime = (Date)this.redisStringAdapter.get(lastReadTimeKey, Date.class);
        if (null == lastReadTime) {
            return resultList;
        }
        long size = this.fillMixRecentlyPool(mixRecentlyPoolKey, lastReadTime, areaCode);
        if (size == 0L) {
            return resultList;
        }
        this.recommendedFilter(mixRecentlyPoolKey, mixRecordKey, num, resultList);
        this.logger.debug("\u540c\u6b65\u63a8\u8350\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        return resultList;
    }

    private long fillMixRecentlyPool(KeyGenerator mixRecentlyPoolKey, Date lastReadTime, String areaCode) {
        List mixRecommendResultList;
        long size = this.redisListAdapter.size(mixRecentlyPoolKey);
        if (size == 0L && (size = (long)(mixRecommendResultList = this.mixedRecommendPoolMapper.selectRecentlyRecommendList(lastReadTime, areaCode)).size()) != 0L) {
            this.redisListAdapter.rightPush(mixRecentlyPoolKey, (Object[])mixRecommendResultList.toArray(new MixRecomendResult[0]));
            this.redisListAdapter.expire(mixRecentlyPoolKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECENTLY_POOL);
        }
        return size;
    }

    protected void recommendedFilter(KeyGenerator mixRecentlyPoolKey, KeyGenerator mixRecordKey, Integer num, List<MixRecomendResult> resultList) {
        long begin = System.currentTimeMillis();
        long total = this.redisListAdapter.size(mixRecentlyPoolKey);
        this.logger.debug("[recentlyRecommendedFilter]redis\u62c9\u53d6\u5217\u8868\u8017\u65f6\uff1a{} \u5217\u8868\u957f\uff1a{}", (Object)(System.currentTimeMillis() - begin), (Object)total);
        if (0L == total) {
            return;
        }
        List mixRecomendResultList = this.redisListAdapter.leftIndex(mixRecentlyPoolKey, total, MixRecomendResult.class);
        Set record = this.redisSetAdapter.getAllMembers(mixRecordKey, Long.class);
        int i = 0;
        for (MixRecomendResult mixRecentlyPoolResult : mixRecomendResultList) {
            if (mixRecentlyPoolResult == null) continue;
            this.generateResult(record, mixRecentlyPoolResult, resultList);
            ++i;
            if (resultList.size() < num) continue;
            this.logger.info("[recentlyRecommendedFilter]\u5df2\u53d6\u5f97{}\u6761\u6700\u65b0\u6df7\u5408\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)num);
            break;
        }
        this.redisListAdapter.leftTrim(mixRecentlyPoolKey, (long)i, total);
        if (!CollectionUtils.isEmpty(resultList)) {
            this.redisSetAdapter.add(mixRecordKey, (Object[])resultList.stream().map(MixRecomendResult::getId).toArray(Long[]::new));
            this.redisSetAdapter.expire(mixRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }
        this.logger.info("[recentlyRecommendedFilter]bloom\u53bb\u91cd\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
    }

    private void generateResult(Set<Long> record, MixRecomendResult mixRecentlyPoolResult, List<MixRecomendResult> resultList) {
        if (!record.contains(mixRecentlyPoolResult.getId())) {
            MixRecomendResult mixRecomendResult = new MixRecomendResult(mixRecentlyPoolResult.getId(), mixRecentlyPoolResult.getOrigin());
            resultList.add(mixRecomendResult);
            record.add(mixRecentlyPoolResult.getId());
        }
    }
}

