/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.LocalnewsRecommendedMapper;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.enums.NewsKindEnum;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.framework.AbstractNewsRecommender;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class LocalNewsRecommender
extends AbstractNewsRecommender {
    private NewsMapper newsMapper;
    private LocalnewsRecommendedMapper localnewsRecommendedMapper;

    @Autowired(required=false)
    public LocalNewsRecommender(NewsMapper newsMapper, RedisListAdapter redisListAdapter, LocalnewsRecommendedMapper localnewsRecommendedMapper, NewsSyncIntegrationService newsSyncIntegrationService) {
        super(0.1, 2);
        this.newsMapper = newsMapper;
        this.redisListAdapter = redisListAdapter;
        this.localnewsRecommendedMapper = localnewsRecommendedMapper;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommend(Long userId, Integer kindId, Integer num, String areaCode) {
        if (StringUtils.isEmpty((String)areaCode)) {
            return new ArrayList<Long>();
        }
        Long province = Long.valueOf(areaCode.substring(0, 2));
        List<Long> originList = this.listLocalnews(userId, kindId, num, province, areaCode);
        ArrayList<Long> result = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(originList)) {
            this.recommendedFilter(originList, num, result, userId);
        }
        return result;
    }

    private List<Long> listLocalnews(Long userId, Integer kindId, Integer num, Long province, String areaCode) {
        List<Long> originList = new ArrayList<Long>();
        if (kindId != null) {
            if (kindId.intValue() == NewsKindEnum.LOCAL.getCode().intValue()) {
                originList = this.localnewsRecommendedMapper.recommendLocalnews(userId, areaCode, province, num);
            }
        } else {
            originList = this.localnewsRecommendedMapper.recommendLocalnewsOfIndex(userId, areaCode, province, Integer.valueOf(num + 5));
        }
        return originList;
    }

    @Override
    protected void asyncRecommend(Long userId, Integer kindId, String areaCode) {
    }
}

