/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.news;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.LocalNewsKindIdConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.param.NewsQueryParam;
import com.bxm.newidea.recommend.framework.AbstractNewsRecommender;
import com.bxm.newidea.service.WeightService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OldMysqlRecNewsRecommender
extends AbstractNewsRecommender {
    private NewsMapper newsMapper;
    private WeightService weightService;
    private DistributedLock distributedLock;

    @Autowired(required=false)
    public OldMysqlRecNewsRecommender(RedisListAdapter redisListAdapter, NewsMapper newsMapper, WeightService weightService, NewsSyncIntegrationService newsSyncIntegrationService, DistributedLock distributedLock) {
        super(1.0, 1);
        this.redisListAdapter = redisListAdapter;
        this.newsMapper = newsMapper;
        this.weightService = weightService;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
        this.distributedLock = distributedLock;
    }

    @Override
    protected List<Long> syncRecommend(Long userId, Integer kindId, Integer num, String areaCode) {
        long begin = System.currentTimeMillis();
        KeyGenerator userCacheKey = RedisKeyConstant.NEWS_NEW_COMMON_RECOMMEND.copy();
        if (kindId != null) {
            userCacheKey.setKey(String.valueOf(kindId));
        }
        userCacheKey.appendKey((Object)userId);
        long size = this.redisListAdapter.size(userCacheKey);
        if (size == 0L) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> resultList = new ArrayList<Long>();
        this.recommendedFilter(userCacheKey, num, resultList, userId);
        this.logger.debug("\u540c\u6b65\u63a8\u8350\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        return resultList;
    }

    @Override
    @Async
    protected void asyncRecommend(Long userId, Integer kindId, String areaCode) {
        this.logger.info("[asyncRecommend][\u65e7\u7248\u9996\u9875\u63a8\u8350]\u5f02\u6b65\u65b9\u6cd5\u8865\u5145\u63a8\u8350\u6c60\uff0c\u7528\u6237\uff1a{}\uff0c\u9891\u9053\uff1a{}\uff0c\u5730\u533a\uff1a{}", new Object[]{userId, kindId, areaCode});
        long current = System.currentTimeMillis();
        NewsQueryParam newsQueryParam = new NewsQueryParam();
        KeyGenerator userCacheKey = this.getUserCacheKey(userId, kindId, areaCode, newsQueryParam);
        int size = this.redisListAdapter.size(userCacheKey).intValue();
        if (kindId != null ? size > NewsCacheThresholdConfig.ALARM_RECOMMEND_CACHE_SIZE : size > NewsCacheThresholdConfig.ALARM_RECOMMEND_OTHER_CACHE_SIZE) {
            return;
        }
        String requestId = String.valueOf(this.nextSequence());
        if (!this.distributedLock.lock(userCacheKey.gen(), requestId)) {
            this.logger.info("[asyncRecommend][\u65e7\u7248\u9996\u9875\u63a8\u8350]\u5f02\u6b65\u5411redis\u4e2d\u586b\u5145\u6570\u636e\u4ecd\u5728\u6267\u884c\u4e2d...\u53d6\u6d88\u6b64\u6b21\u6267\u884c,\u53c2\u6570-userId:{},kindId:{}", (Object)userId, (Object)kindId);
            return;
        }
        long currentRecalcu = System.currentTimeMillis();
        this.weightService.recalcu(userId);
        this.logger.debug("[asyncRecommend][\u65e7\u7248\u9996\u9875\u63a8\u8350]\u7ed9{}\u8fdb\u884c\u7528\u6237\u6807\u7b7e\u91cd\u7f6e \u82b1\u8d39\u65f6\u95f4{}", (Object)userId, (Object)(System.currentTimeMillis() - currentRecalcu));
        List<Long> result = this.generateNews(newsQueryParam, userId, kindId);
        Object[] newsDtos = result.toArray(new Long[0]);
        this.redisListAdapter.remove(userCacheKey);
        this.redisListAdapter.rightPush(userCacheKey, newsDtos);
        this.redisListAdapter.expire(userCacheKey, 3600L);
        this.logger.info("[asyncRecommend][\u65e7\u7248\u9996\u9875\u63a8\u8350]\u4e3a{}\u8fdb\u884c\u9891\u9053\u4e3a{}\u7684\u65b0\u95fb\u63a8\u8350 \u7ed3\u679c\uff1a{}\u3002\u82b1\u8d39\u65f6\u95f4{}", new Object[]{userId, kindId == null ? "\u63a8\u8350" : kindId, newsDtos.length, System.currentTimeMillis() - current});
        this.distributedLock.unlock(userCacheKey.toString(), requestId);
    }

    private KeyGenerator getUserCacheKey(Long userId, Integer kindId, String areaCode, NewsQueryParam newsQueryParam) {
        KeyGenerator userCacheKey = RedisKeyConstant.NEWS_NEW_COMMON_RECOMMEND.copy();
        if (kindId != null) {
            userCacheKey.setKey(String.valueOf(kindId));
            newsQueryParam.setKindId(Long.valueOf(kindId.intValue()));
            if (kindId.intValue() == LocalNewsKindIdConstant.LOCAL_NEWS.intValue()) {
                userCacheKey.appendKey((Object)areaCode);
                newsQueryParam.setKindId(null);
                newsQueryParam.setAreaCode(areaCode);
            }
        }
        userCacheKey.appendKey((Object)userId);
        return userCacheKey;
    }

    private List<Long> generateNews(NewsQueryParam newsQueryParam, Long userId, Integer kindId) {
        List result;
        newsQueryParam.setIsHot(Integer.valueOf(1));
        newsQueryParam.setUserId(userId);
        if (kindId != null) {
            newsQueryParam.setPagesize(Integer.valueOf(NewsCacheThresholdConfig.MAX_RECOMMEND_CACHE_SIZE));
            result = this.newsMapper.recommendNews(newsQueryParam);
            if (result.size() < NewsCacheThresholdConfig.ALARM_RECOMMEND_CACHE_SIZE) {
                result = this.newsMapper.recommendNewsWithoutTime(newsQueryParam);
                this.logger.info("[generateNews][\u65e7\u7248\u9996\u9875\u63a8\u8350]\u7531\u4e8e\u65b0\u95fb\u65f6\u6548\u6027\u5bfc\u81f4\u63a8\u8350\u8fc7\u5c11,\u6240\u4ee5\u91cd\u65b0\u8fdb\u884c\u4e00\u6b21\u63a8\u8350,\u53c2\u6570\uff1a{}\uff0c\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)newsQueryParam), (Object)result.size());
            }
        } else {
            newsQueryParam.setPagesize(Integer.valueOf(NewsCacheThresholdConfig.MAX_RECOMMEND_OTHER_CACHE_SIZE));
            result = this.newsMapper.recommendOtherNews(newsQueryParam);
            if (result.size() < NewsCacheThresholdConfig.ALARM_RECOMMEND_OTHER_CACHE_SIZE) {
                result = this.newsMapper.recommendOtherNewsWithoutTime(newsQueryParam);
                this.logger.info("[generateNews][\u65e7\u7248\u9996\u9875\u63a8\u8350]\u7531\u4e8e\u65b0\u95fb\u65f6\u6548\u6027\u5bfc\u81f4\u63a8\u8350\u8fc7\u5c11,\u6240\u4ee5\u91cd\u65b0\u8fdb\u884c\u4e00\u6b21\u63a8\u8350,\u53c2\u6570\uff1a{}\uff0c\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)newsQueryParam), (Object)result.size());
            }
        }
        return result;
    }
}

