package com.bxm.newidea.config;

/**
 * 推荐新闻缓存池阀值配置
 */
public class NewsCacheThresholdConfig {

    /**
     * 缓存池大小
      */
    public static int MAX_CACHE_SIZE = 200;

    /**
     * 警戒缓存阀值（缓存池低于此阀值时则需要进行异步推荐）
     */
    public static int ALARM_CACHE_SIZE = 100;

    /**
     * 2.0.0推荐-缓存池大小
     */
    public static int MAX_RECOMMEND_CACHE_SIZE = 30;

    /**
     * 2.0.0推荐-其它缓存池大小
     */
    public static int MAX_RECOMMEND_OTHER_CACHE_SIZE = 60;

    /**
     * 2.0.0推荐-缓存池警戒缓存阀值（缓存池低于此阀值时则需要进行异步推荐）
     */
    public static int ALARM_RECOMMEND_CACHE_SIZE = 10;

    /**
     * 2.0.0推荐-其它缓存池警戒缓存阀值（缓存池低于此阀值时则需要进行异步推荐）
     */
    public static int ALARM_RECOMMEND_OTHER_CACHE_SIZE = 20;

    /**
     * 2.1.0推荐-最后阅读时间[redis过期时间]
     */
    public static int MIX_EXPIRE_LAST_READ_TIME = 7*24*60*60;

    /**
     * 2.1.0推荐-固定推荐池索引位置[redis过期时间]
     */
    public static int MIX_EXPIRE_FIX_INDEX = 7*24*60*60;

    /**
     * 2.1.0推荐-最新推荐池[redis过期时间]
     */
    public static int MIX_EXPIRE_RECENTLY_POOL = 60*60;

    /**
     * 2.1.0推荐-用户阅读记录[redis过期时间]
     */
    public static int MIX_EXPIRE_RECOMMENDED_RECORD = 7*24*60*60;

    /**
     * 2.2.0推荐-用户阅读记录[redis过期时间]
     */
    public static int NEWS_EXPIRE_RECOMMENDED_RECORD = 7*24*60*60;


}
