package com.bxm.newidea.recommend;


import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.param.MixRecommendParam;
import com.bxm.newidea.param.NewsRecommendParam;

import java.util.List;
import java.util.Objects;

/**
 * 推荐器抽象类
 */
public abstract class AbstractRecommender extends BaseService {

    private double weight;

    private int sort;

    public AbstractRecommender(double weight, int sort) {
        this.weight = weight;
        this.sort = sort;
    }

    public Double getWeight() {
        return weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    /**------ 推荐分类 ------*/
    /**
     * 新闻推荐
     * @param newsRecommendParam
     * @return
     */
    public List<Long> recommend(NewsRecommendParam newsRecommendParam){return null;}

    /**
     * 小视频推荐
     * @param user
     * @param num
     * @return
     */
    public List<VideoDto> recommend(Long user, Integer num){return null;}

    /**
     * 混合推荐
     * @param mixRecommendParam
     * @return
     */
    public List<MixRecomendResult> recommend(MixRecommendParam mixRecommendParam){return null;}

    /**
     * 帖子推荐
     * @param forumParam
     * @return
     */
    public List<Long> recommend(ForumParam forumParam){return null;}

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AbstractRecommender that = (AbstractRecommender) o;
        return Double.compare(that.weight, weight) == 0 &&
                sort == that.sort;
    }

    @Override
    public int hashCode() {
        return Objects.hash(weight, sort);
    }
}
