package com.bxm.newidea.recommend;

import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.handler.mix.CommonMixRecommender;
import com.bxm.newidea.recommend.handler.mix.FixMixRecommender;
import com.bxm.newidea.recommend.handler.mix.RecentlyMixRecommender;
import com.bxm.newidea.recommend.handler.news.*;
import com.bxm.newidea.recommend.handler.video.EmergencyVideoRecommender;
import com.bxm.newidea.recommend.handler.video.OldMysqlVideoRecommender;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 推荐器工厂类，简单搞简单做
 * TODO 配置方式可以优化 后续做
 */
@Component
public class RecommendManager implements ApplicationContextAware, InitializingBean {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    private EmergencyNewsRecommender emergencyNewsRecommender;

    private OldMysqlNewsRecommender oldMysqlNewsRecommender;

    private OldMysqlVideoRecommender mysqlVideoRecommender;

    private EmergencyVideoRecommender emergencyVideoRecommender;

    private LocalNewsRecommender localNewsRecommender;

    private HotNewsRecommender hotNewsRecommender;

    private OldMysqlRecNewsRecommender oldMysqlRecNewsRecommender;

    private FixMixRecommender fixMixRecommender;

    private RecentlyMixRecommender recentlyMixRecommender;

    private ApplicationContext applicationContext;

    private CommonMixRecommender commonMixRecommender;

    /**
     * 所有推荐器实现类
     */
    private Map<String,AbstractRecommender> allRecommender;
    /**
     * 运营位和推荐器映射
     */
    private static Map<Integer,String> operationRecommenderMap;

    static {
        // 初始化运营位和推荐器映射
        operationRecommenderMap = new ConcurrentHashMap<>();
        // 论坛首页
        operationRecommenderMap.put(OperationLocationEnum.FORUM_HOME_PAGE.getCode(),"forumCommonRecommender");
        // 板块精华
        operationRecommenderMap.put(OperationLocationEnum.FORUM_PLATE_ELITE.getCode(),"forumCommonRecommender");
        // 板块最新
        operationRecommenderMap.put(OperationLocationEnum.FORUM_PLATE_NEWEST.getCode(),"forumCommonRecommender");
        // 话题最新
        operationRecommenderMap.put(OperationLocationEnum.FORUM_TOPIC_NEWEST.getCode(),"forumCommonRecommender");
        // 话题热门
        operationRecommenderMap.put(OperationLocationEnum.FORUM_TOPIC_HOT.getCode(),"forumTopicHotRecommender");
        // 论坛帖子详情
        operationRecommenderMap.put(OperationLocationEnum.FORUM_POST_DETAIL.getCode(),"forumDetailRecommender");
    }

    @Autowired
    public RecommendManager(EmergencyNewsRecommender emergencyNewsRecommender,
                            OldMysqlNewsRecommender oldMysqlNewsRecommender,
                            OldMysqlVideoRecommender mysqlVideoRecommender,
                            EmergencyVideoRecommender emergencyVideoRecommender,
                            LocalNewsRecommender localNewsRecommender,
                            HotNewsRecommender hotNewsRecommender,
                            OldMysqlRecNewsRecommender oldMysqlRecNewsRecommender,
                            FixMixRecommender fixMixRecommender,
                            RecentlyMixRecommender recentlyMixRecommender,
                            CommonMixRecommender commonMixRecommender) {
        this.emergencyNewsRecommender = emergencyNewsRecommender;
        this.oldMysqlNewsRecommender = oldMysqlNewsRecommender;
        this.mysqlVideoRecommender = mysqlVideoRecommender;
        this.emergencyVideoRecommender = emergencyVideoRecommender;
        this.localNewsRecommender = localNewsRecommender;
        this.hotNewsRecommender = hotNewsRecommender;
        this.oldMysqlRecNewsRecommender = oldMysqlRecNewsRecommender;
        this.fixMixRecommender = fixMixRecommender;
        this.recentlyMixRecommender = recentlyMixRecommender;
        this.commonMixRecommender = commonMixRecommender;
    }

    public List<AbstractRecommender> getNewsRecommenders() {
        List<AbstractRecommender> list = new ArrayList<>();
        list.add(oldMysqlNewsRecommender);
        list.add(emergencyNewsRecommender);
        return list;
    }

    public List<AbstractRecommender> getVideoRecommenders() {
        List<AbstractRecommender> list = new ArrayList<>();
        list.add(mysqlVideoRecommender);
        list.add(emergencyVideoRecommender);
        return list;
    }

    public List<AbstractRecommender> getCommonNewsRecommenders() {
        List<AbstractRecommender> list = new ArrayList<>();
        list.add(oldMysqlRecNewsRecommender);
        list.add(emergencyNewsRecommender);
        return list;
    }

    public List<AbstractRecommender> getMixRecommenders(){
        List<AbstractRecommender> list = new ArrayList<>();
        list.add(commonMixRecommender);
        return list;
    }

    public AbstractRecommender getLocalNewsRecommender() {
        return localNewsRecommender;
    }

    public AbstractRecommender getHotNewsRecommender() {
        return hotNewsRecommender;
    }

    public AbstractRecommender getForumRecommender(ForumParam forumParam) {
        String recommenderName = operationRecommenderMap.get(forumParam.getOperationId());
        if (StringUtils.isBlank(recommenderName)) {
            logger.error("specified recommendable does not exist,operationId {},userId {},areacode:{}", forumParam.getOperationId(), forumParam.getUserId(), forumParam.getAreaCode());
            return null;
        }
        return allRecommender.get(recommenderName);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.allRecommender = applicationContext.getBeansOfType(AbstractRecommender.class);
    }
}
