package com.bxm.newidea.recommend.engine;

import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.recommend.RecommendManager;
import com.bxm.newidea.recommend.filter.RecommendFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ForumRecommendEngine {

    private Logger logger = LoggerFactory.getLogger(ForumRecommendEngine.class);

    private RecommendFilter recommendFilter;

    private RecommendManager recommendManager;

    @Autowired
    public ForumRecommendEngine(RecommendManager recommendManager,
                                RecommendFilter recommendFilter) {
        this.recommendManager = recommendManager;
        this.recommendFilter = recommendFilter;
    }

    public List<Long> recommend(ForumParam forumParam) {

        List<Long> forumPostList = new LinkedList<>();

        //1.获得帖子推荐器
        AbstractRecommender recommenderWorkers = recommendManager.getForumRecommender(forumParam);
        if (null != recommenderWorkers) {
            //2.如果有多个推荐器则循环调用
            forumPostList = recommenderWorkers.recommend(forumParam);
        }
        return forumPostList;
    }

}
