package com.bxm.newidea.recommend.engine;

import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.param.MixQueryParam;
import com.bxm.newidea.param.MixRecommendParam;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.recommend.RecommendManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class MixRecommendEngine {

    private Logger logger = LoggerFactory.getLogger(MixRecommendEngine.class);

    private RecommendManager recommendManager;

    @Autowired
    public MixRecommendEngine(RecommendManager recommendManager) {
        this.recommendManager = recommendManager;
    }

    public List<MixRecomendResult> recommendMixResult(MixQueryParam mixQueryParam){

        int num = mixQueryParam.getPageSize();
        Long userId = mixQueryParam.getUserId();

        MixRecommendParam mixRecommendParam = new MixRecommendParam()
                .setAreaCode(mixQueryParam.getAreaCode())
                .setActionType(mixQueryParam.getActionType())
                .setPlatform(mixQueryParam.getPlatform())
                .setUserId(userId);

        List<MixRecomendResult> mixRecommendResultList = new LinkedList<>();
        //1.获得混合推荐器
        List<AbstractRecommender> recommenderWorkers = recommendManager.getMixRecommenders();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();


        //2.如果有多个推荐器则循环调用
        //想要推荐的数量
        int fetchNum;
        //已推荐的数量
        int recommendNum = 0;
        while (iterator.hasNext()) {
            AbstractRecommender recommender = iterator.next();
            //获取推荐器权重对应的推荐数量
            fetchNum = num;
            //如果权重推荐数量大于剩余推荐数量，则选择剩余数量
            if (num - recommendNum < fetchNum) {
                fetchNum = num - recommendNum;
            }

            List<MixRecomendResult> results = recommender.recommend(mixRecommendParam.setNum(fetchNum));
            recommendNum += results.size();
            mixRecommendResultList.addAll(results);

            if (mixRecommendResultList.size() >= num) {
                break;
            }
        }

        //3.全局黑名单过滤
        //mixRecomendResultList = recommendFilter.newsFilter(mixRecomendResultList);

        //4.去重
        mixRecommendResultList = removeDuplicateMixResult(mixRecommendResultList);

        return mixRecommendResultList.size() > num ? mixRecommendResultList.subList(0, num) : mixRecommendResultList;
    }


    private List<MixRecomendResult> removeDuplicateMixResult(List<MixRecomendResult> list) {
        return list.stream().distinct().collect(Collectors.toList());
    }
}
