package com.bxm.newidea.recommend.engine;

import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.recommend.filter.RecommendFilter;
import com.bxm.newidea.recommend.RecommendManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@Service
public class VideoRecommendEngine {

    private Logger logger = LoggerFactory.getLogger(VideoRecommendEngine.class);

    private RecommendFilter recommendFilter;

    private RecommendManager recommendManager;

    @Autowired
    public VideoRecommendEngine(RecommendManager recommendManager,
                                RecommendFilter recommendFilter) {
        this.recommendManager = recommendManager;
        this.recommendFilter = recommendFilter;
    }

    public List<VideoDto> recommendVideo(Long userId, Integer num) {
        //1.获得小视频推荐器
        List<AbstractRecommender> recommenderWorkers = recommendManager.getVideoRecommenders();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();
        logger.debug("视频新闻推荐引擎调用链：{}", recommenderWorkers);
        List<VideoDto> videoDtoList = new LinkedList<>();

        //2.如果有多个推荐器则循环调用
        int fetchNum;
        int differenceNum = 0;
        while (iterator.hasNext()) {
            AbstractRecommender recommender = iterator.next();
            fetchNum = new BigDecimal(num).multiply(new BigDecimal(recommender.getWeight())).intValue() + differenceNum;
            List<VideoDto> results = recommender.recommend(userId, fetchNum);
            logger.debug("推荐器：{} 推荐结果：{}", recommender.getClass(), results.size());
            differenceNum = fetchNum - results.size();
            videoDtoList.addAll(results);
            if (videoDtoList.size() == num) {
                break;
            }
        }

        //3.全局黑名单过滤
        videoDtoList = recommendFilter.videoFilter(videoDtoList);

        //4.去重
        videoDtoList = removeDuplicateVideo(videoDtoList);

        return videoDtoList.size() > num ? videoDtoList.subList(0, num) : videoDtoList;
    }

    private List<VideoDto> removeDuplicateVideo(List<VideoDto> list) {
        HashSet<VideoDto> h = new HashSet<>(list);
        list.clear();
        list.addAll(h);
        return list;
    }
}
