package com.bxm.newidea.recommend.framework;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.AbstractRecommender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public abstract class AbstractForumRecommender extends AbstractRecommender {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractForumRecommender(double weight, int sort) {
        super(weight, sort);
    }

    @Override
    public List<Long> recommend(ForumParam param) {
        long begin = System.currentTimeMillis();

        //1.同步推荐获取结果集
        List<Long> ids = this.syncRecommend(param);

        //2.异步处理
        AbstractForumRecommender recommender = SpringContextHolder.getBean(this.getClass());
        recommender.asyncRecommend(param);

        logger.info("推荐结果：{},参数:{},耗时：{}", ids == null ? 0 : JSONObject.toJSONString(ids),JSONObject.toJSON(param), System.currentTimeMillis() - begin);

        return ids;
    }

    /**
     * 同步推荐
     * @param param
     * @return 推荐结果(newsId list)
     */
    protected abstract List<Long> syncRecommend(ForumParam param);

    /**
     * 异步推荐
     * @param param
     */
    protected void asyncRecommend(ForumParam param){};
}
