package com.bxm.newidea.recommend.framework;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.MixRecommendParam;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.vo.CircleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractMixRecommender extends AbstractRecommender {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected RedisListAdapter redisListAdapter;

    protected RedisSetAdapter redisSetAdapter;

    protected RedisStringAdapter redisStringAdapter;

    protected MixedRecommendPoolMapper mixedRecommendPoolMapper;

    public static HashMap<String, CircleNode[]> mixRecommendResults = new HashMap<>();

    public AbstractMixRecommender(double weight, int sort) {
        super(weight, sort);
    }

    @Override
    public List<MixRecomendResult> recommend(MixRecommendParam param){
        long begin = System.currentTimeMillis();

        int num = param.getNum();
        Long userId = param.getUserId();
        String areaCode = param.getAreaCode();
        Integer actionType = param.getActionType();

        //1.同步推荐获取结果集
        List<MixRecomendResult> ids = this.syncRecommend(userId, actionType, num, areaCode,param.getPlatform());

        //2.异步处理
        AbstractMixRecommender recommender = SpringContextHolder.getBean(this.getClass());
        recommender.asyncRecommend(userId,ids,param.getPlatform());

        logger.info("推荐结果:{},参数:{}, 耗时:{}", ids == null ? 0 : JSONObject.toJSONString(ids),JSONObject.toJSONString(param), System.currentTimeMillis() - begin);
        return ids;
    }

    /**
     * 同步推荐（处理同步操作）
     * @param userId
     * @param actionType
     * @param num
     * @param areaCode
     * @return
     */
    protected abstract List<MixRecomendResult> syncRecommend(Long userId, Integer actionType, Integer num, String areaCode,int platform);

    /**
     * 异步推荐（处理异步操作）
     * @param userId 用户id
     */
    @Async
    protected void asyncRecommend(Long userId,List<MixRecomendResult> mixRecomendResults,Integer platform){
        KeyGenerator mixLastReadTimeKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(platform).appendKey(OperationLocationEnum.HOME_PAGE.getName()).appendKey("lastreadtime");
        //存放最后阅读时间，设置7天过期
        if (mixRecomendResults != null && !mixRecomendResults.isEmpty()) {
            redisStringAdapter.set(mixLastReadTimeKey,new Date(),NewsCacheThresholdConfig.MIX_EXPIRE_LAST_READ_TIME);
        }
    }
}
