package com.bxm.newidea.recommend.framework;


import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.VideoRecommendMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.AbstractRecommender;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractVideoRecommender extends AbstractRecommender {

    protected RedisListAdapter redisListAdapter;

    protected VideoRecommendMapper videoRecommendMapper;

    public AbstractVideoRecommender(double weight, int sort) {
        super(weight, sort);
    }

    @Override
    public List<VideoDto> recommend(Long userId, Integer num) {
        //1.同步推荐
        List<VideoDto> videoDtos = syncRecommend(userId, num);
        //2.本次推荐结果写入已推荐缓存
        if (videoDtos != null && !videoDtos.isEmpty()) {
            List<Long> ids = new ArrayList<>();
            videoDtos.forEach(videoDto -> ids.add(videoDto.getId()));
            KeyGenerator recommendedNewsKey = RedisKeyConstant.VIDEO_RECOMMENDED.copy().appendKey(userId);
            redisListAdapter.rightPush(recommendedNewsKey, ids.toArray(new Long[0]));
            videoRecommendMapper.batchInsert(userId, ids);
        }
        AbstractVideoRecommender recommender = SpringContextHolder.getBean(this.getClass());
        //3.异步推荐
        recommender.asyncRecommend(userId);
        return videoDtos;
    }

    /**
     * 同步推荐
     * @param userId 用户id
     * @param num    推荐数量
     * @return 推荐结果(newsId list)
     */
    protected abstract List<VideoDto> syncRecommend(Long userId, Integer num);

    /**
     * 异步推荐
     * @param userId 用户id
     */
    protected abstract void asyncRecommend(Long userId);
}
