package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.AppConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.service.ForumService;
import com.bxm.newidea.service.MixRecommendService;
import com.bxm.newidea.vo.CircleNode;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

import static com.bxm.newidea.constant.AppConstant.FIX_POOL_SIZE;

@Component
@Deprecated
public class FixForumHomePageRecommender extends AbstractForumRecommender {

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private ForumPostMapper forumPostMapper;

    @Autowired
    private ForumService forumService;

    @Autowired
    private MixRecommendService mixRecommendService;

    public FixForumHomePageRecommender() {
        super(1, 1);
    }

    public static HashMap<String,CircleNode[]> postRecommendResults = new HashMap<>();

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        long begin = System.currentTimeMillis();

        Long userId = forumParam.getUserId();
        Integer operationId = forumParam.getOperationId();

        // 已推荐redis key
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(OperationLocationEnum.getName(operationId)).appendKey("browsingKey");
        // 最后一次推荐记录
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(OperationLocationEnum.getName(operationId)).appendKey("lastreadtime");
        // 游标
        KeyGenerator indexKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(OperationLocationEnum.getName(operationId)).appendKey("index");

        List<Long> resultList = new ArrayList<>();

        //1.获得固定池的游标
        int index = getInitIndex(forumParam.getUserId(),lastRecommendedKey,indexKey);
        logger.info("[syncRecommendPost]固定推荐池游标：{}", index);

        //2.获得固定池数据
        CircleNode[] postRecommendResultArray = this.getData(forumParam.getAreaCode());
        logger.info("[syncRecommendPost]固定推荐库容量：{}", postRecommendResultArray!=null?postRecommendResultArray.length:0);
        if (postRecommendResultArray == null || postRecommendResultArray.length==0) {
            return new ArrayList<>();
        }

        //3.进行遍历筛选
        recommendedFilter(postRecommendResultArray, recommendedKey,indexKey, index, forumParam.getPageSize(), forumParam.getActionType(), resultList,userId,forumParam.getPlatform());
        if (CollectionUtils.isNotEmpty(resultList)) {
            redisStringAdapter.set(lastRecommendedKey,new Date(),NewsCacheThresholdConfig.MIX_EXPIRE_LAST_READ_TIME);
        }
        logger.debug("同步推荐耗时：{}", System.currentTimeMillis() - begin);
        return resultList;
    }

    private CircleNode[] getData(String areaCode){
        CircleNode[] postRecommendResultArray = postRecommendResults.get(areaCode);
        if (postRecommendResultArray == null || postRecommendResultArray.length == 0) {
            List<Long> postRecommendResultList = forumPostMapper.selectFixPostList(FIX_POOL_SIZE, areaCode);
            if (CollectionUtils.isNotEmpty(postRecommendResultList)) {
                postRecommendResultArray = forumService.getCircleNode(postRecommendResultList);
                postRecommendResults.put(areaCode, postRecommendResultArray);
            }
        }
        return postRecommendResultArray;
    }

    /**
     * 下拉刷新
     * 下拉刷新时，会清空之前的推荐记录，并且循环取数据
     * @param circleNodes 循环数组
     * @param resultList 结果集
     * @param mixRecordKey 用户短期推荐记录
     * @param fromIndex 起始游标
     * @param num 本次推荐的数量
     * @param userId 用户id
     */
    private void doDownRefresh(CircleNode[] circleNodes,
                               List<Long> resultList,
                               KeyGenerator mixRecordKey,
                               KeyGenerator indexKey,
                               Integer fromIndex,
                               Integer num,
                               Long userId,
                               int plaform) {

        //1.获得循环数组总量看，也就是最大循环次数
        int total = circleNodes.length;

        //2.当用户切换地区时，需要清空混合推荐用户缓存，当其中逻辑失败时，需要在这里做二次保险
        if (fromIndex >= total) {
            fromIndex = 0;
            this.mixRecommendService.cleanMixCache(userId,plaform);
        }

        //3.设置循环指针下标位置
        int next = fromIndex;
        Set<Long> record = redisSetAdapter.getAllMembers(mixRecordKey,Long.class);
        for (int i = 0; i < total; i++) {

            //4.取得当前游标的值
            CircleNode circleNode = circleNodes[next];

            //5.初始判断是否与之前的最新推荐池id或者本次的固定推荐池id重复，如果不重复则将其加入结果，并加入临时推荐记录做去重准备

            this.generateResult(record,mixRecordKey,circleNode,resultList);

            //7.如果没有达到数量上的要求,则继续循环，需要设置下一次的循环指针下标，如果当前在池底，则next指向0
            next = circleNode.getNext();

            //6.一旦数量达标，则退出循环
            if (resultList.size()>=num) {
                logger.info("[doDownRefresh]已取得{}条混合推荐数据，功成圆满,游标：{}",num,next);
                break;
            }

        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            redisSetAdapter.add(mixRecordKey, resultList.toArray(new Long[0]));
            redisSetAdapter.expire(mixRecordKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            redisStringAdapter.set(indexKey, next, NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        }
        logger.info("[doDownRefresh]结束遍历,数量：{},游标：{}",resultList.size(),next);
    }

    /**
     * 上划刷新
     * @param circleNodes 循环数组
     * @param resultList 结果集
     * @param mixRecordKey 用户短期推荐记录
     * @param fromIndex 起始游标
     * @param num 本次推荐的数量
     * @param userId 用户id
     */
    private void doUpRefresh(CircleNode[] circleNodes,
                             List<Long> resultList,
                             KeyGenerator mixRecordKey,
                             KeyGenerator indexKey,
                             int fromIndex,
                             int num,
                             Long userId,
                             int platfrom) {

        //1.获得循环数组总量看，也就是最大循环次数
        int total = circleNodes.length;

        //2.当用户切换地区时，需要清空混合推荐用户缓存，当其中逻辑失败时，需要在这里做二次保险
        if (fromIndex >= total) {
            fromIndex = 0;
            mixRecommendService.cleanMixCache(userId,platfrom);
        }

        //3.设置循环指针下标位置
        int next = fromIndex;
        Set<Long> record = redisSetAdapter.getAllMembers(mixRecordKey,Long.class);
        for (int i = 0; i < total; i++) {

            //4.取得当前游标的值
            CircleNode circleNode = circleNodes[next];

            //5.初始判断是否与之前的最新推荐池id或者本次的固定推荐池id重复，如果不重复则将其加入结果，并加入临时推荐记录做去重准备
            this.generateResult(record,mixRecordKey,circleNode,resultList);

            //7.如果没有达到数量上的要求,则继续循环，需要设置下一次的循环指针下标，如果当前在池底，则next指向0
            next = circleNode.getNext();

            //6.一旦数量达标，则退出循环
            if (resultList.size()>=num) {
                logger.info("[doUpRefresh]已取得{}条混合推荐数据，功成圆满",num);
                break;
            }
        }

        if (CollectionUtils.isNotEmpty(resultList)) {
            redisSetAdapter.add(mixRecordKey, resultList.toArray(new Long[0]));
            redisSetAdapter.expire(mixRecordKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }

        if (next == fromIndex) {
            redisStringAdapter.set(indexKey, 0, NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        } else {
            redisStringAdapter.set(indexKey, next, NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        }
        logger.info("[doUpRefresh]已取得{}条混合推荐数据，功成圆满",num);
    }

    /**
     * 判断是否已被推荐过，如果没有则加入结果集并加入推荐记录
     *
     * @param mixRecordKey          推荐记录key
     * @param mixRecordKey 当前的数据
     * @param resultList            结果集
     */
    private void generateResult(Set<Long> record,KeyGenerator mixRecordKey, CircleNode circleNode, List<Long> resultList) {
        if (!record.contains(circleNode.getId())) {
            resultList.add(circleNode.getId());
            record.add(circleNode.getId());
        }
    }

    /**
     * 去重（固定推荐库）
     *
     * @param fromIndex              开始索引
     * @param num                    本次数量
     * @param actionType             动作 ，下拉还是上滑
     * @param resultList             结果数据
     * @param userId                 用户id
     */
    protected void recommendedFilter(CircleNode[] circleNodes,
                                     KeyGenerator mixRecordKey,
                                     KeyGenerator indexKey,
                                     Integer fromIndex,
                                     Integer num,
                                     Integer actionType,
                                     List<Long> resultList,
                                     Long userId,
                                     int platform) {
        if (actionType.equals(AppConstant.ACTION_TYPE_DOWN)) {
            doDownRefresh(circleNodes,resultList, mixRecordKey,indexKey, fromIndex, num, userId,platform);
        } else if (actionType.equals(AppConstant.ACTION_TYPE_UP)) {
            doUpRefresh(circleNodes,resultList,mixRecordKey,indexKey, fromIndex, num, userId,platform);
        }
    }

    /**
     * 得到用户的游标，也就是上一次的阅读记录
     * @param userId 用户id
     * @return
     */
    private int getInitIndex(Long userId,KeyGenerator lastRecommendedKey,KeyGenerator indexKey) {
        int index;
        if (redisStringAdapter.getString(lastRecommendedKey).isEmpty()) {
            //如果用户没有最后的阅读时间记录，则说明用户没有看过首页的东西，直接按index为0来处理，从头看起
            index = 0;
        } else {
            index = redisStringAdapter.getInt(indexKey);
        }
        return index;
    }




}
