package com.bxm.newidea.recommend.handler.forum;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.constant.AppConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.domain.LocalnewsRecommendedMapper;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.properties.RecommendProperties;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.util.ObjectUtil;
import com.bxm.newidea.vo.ForumPost;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.groupingBy;

/**
 * <p>
 *     论坛帖子详情推荐器：
 *          tag相关联
 *          两条本地新闻
 *          三条本地帖子
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/3
 */
@Service
public class ForumDetailRecommender extends AbstractForumRecommender {
    private static final Logger LOG = LoggerFactory.getLogger(ForumDetailRecommender.class);

    @Autowired
    private ForumPostMapper forumPostMapper;

    @Autowired
    private LocalnewsRecommendedMapper localNewsMapper;

    @Autowired
    private RecommendProperties recommendProperties;

    @Autowired
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;

    public ForumDetailRecommender() {
        super(1,1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {

        Set<Long> result = Sets.newHashSet();
        if(null == forumParam.getPostId()){
            LOG.warn("[forum detail] post_id is null");
            return Lists.newArrayList(result);
        }
        // 获取指定条数相关新闻
        Long province = Long.valueOf(forumParam.getAreaCode().substring(0, 2));
        int newsNum = AppConstant.FORUM_DETAIL_LOCAL_NEWS ;
        List<Long> newsList = localNewsMapper.findNewsByForumTag(forumParam.getAreaCode(),forumParam.getPostId(),province,forumParam.getUserId(),newsNum);
        logger.debug("tag标签匹配新闻数量:{}",JSONObject.toJSONString(newsList));
        result.addAll(newsList);
        // 获取足够多相关帖子
        int postNum =  AppConstant.FORUM_DETAIL_LOCAL_POST ;
        List<Long> postIds = getPostId(forumParam, postNum);
        result.addAll(postIds);

        if (forumParam.getPlatform() == 3){
            //H 5 推荐
            return  getResultToH5(result,forumParam.getAreaCode(),forumParam.getPostId());
        }else {
            //客户端 推荐
            return getResultToClient(result,newsNum + postNum,forumParam.getAreaCode(),forumParam.getPostId());
        }


    }

    //填充客户端数量
    public  List<Long> getResultToClient(Set<Long> result, int size,String areaCode ,Long id) {
        Set<Long> removeId = Sets.newHashSet(id);
        if (result.size() < size){
            //当数据不够是去推荐库填充
            List<MixRecomendResult> list = mixedRecommendPoolMapper.selectLastRecommendList(null, areaCode, 30, removeId);
            logger.debug("推荐库获得数量:{}", JSONObject.toJSONString(list));
            while(CollectionUtils.isNotEmpty(list)){
                int i = RandomUtils.nextInt(0, list.size() - 1);
                MixRecomendResult recomendResult = list.get(i);
                result.add(recomendResult.getId());
                list.remove(recomendResult);
                if (result.size() >= size ){
                    break;
                }
            }
        }
        return Lists.newArrayList(result);

    }


    /**
     * 获得H5 推荐
     * @param result
     * @param areaCode
     * @param id 当前推荐id
     * @return
     */
    public List<Long> getResultToH5(Set<Long> result, String areaCode,Long id) {
        List<Long> objects = Lists.newLinkedList();
        Set<Long> mixResult = getMixRecommand(result, areaCode, AppConstant.FORUM_DETAIL_All - result.size(),id);
        logger.debug("推荐库推荐数据[{}]",JSONObject.toJSONString(mixResult));
        for (int i = 0 ; i < AppConstant.FORUM_DETAIL_All ; i++ ){
            if ( i % 2 == 0 || result.isEmpty()){
                Optional<Long> mix = mixResult.stream().findFirst();
                if (mix.isPresent()){
                    objects.add(mix.get());
                    mixResult.remove(mix.get());
                }
            }else{
                Optional<Long> newAndPost = result.stream().findFirst();
                objects.add(newAndPost.get());
                result.remove(newAndPost.get());
            }
        }
        return objects;
    }

    /**
     * 在推荐库中获取推荐内容,并去重
     * @param result
     * @param result
     * @param mixNum 推荐数量
     * @param id 当前推荐id
     * @return
     */
    private Set<Long> getMixRecommand(Set<Long> result,String areaCode,int mixNum,Long id){
        final int pageSize = 30;
        Set<Long> mixResult = Sets.newHashSet();
        Set<Long> removeId = Sets.newHashSet(id);
        List<MixRecomendResult> list = mixedRecommendPoolMapper.selectLastRecommendList(null, areaCode, pageSize, removeId);
        while (CollectionUtils.isNotEmpty(list) ) {
            int i = RandomUtils.nextInt(0, list.size() - 1);
            MixRecomendResult recomendResult = list.get(i);
            if (!result.contains(recomendResult.getId())) {
                mixResult.add(recomendResult.getId());
            }
            list.remove(recomendResult);
            if (mixResult.size() >= mixNum) {
                break;
            }
        }
        return mixResult;
    }


    /**
     * 获得足够多的帖子数量
      * @param forumParam
     * @param postNum
     * @return
     */
    private List<Long>  getPostId(ForumParam forumParam,int postNum){
        List<Long> result = Lists.newArrayList();
        List<Long> filterForumId = recommendProperties.getFilterForumId();
        int enoughPostNum = 100;
        List<ForumPost> forumList = forumPostMapper.findForumPostByTag(forumParam.getPostId(), enoughPostNum,forumParam.getAreaCode(),filterForumId);
        Map<Long, List<ForumPost>> collect = forumList.stream().collect(groupingBy(ForumPost::getUserId));
        Set<Long> userIds = collect.keySet();
        for (Long userid: userIds) {
            List<ForumPost> forumPosts = collect.get(userid);
            Optional<ForumPost> first = forumPosts.stream().findFirst();
            if (first.isPresent()){
                result.add(first.get().getId());
            }
            if (result.size() >= postNum){
                break;
            }
        }
        logger.debug("tag标签匹配帖子数量:{}",JSONObject.toJSONString(result));
        return result;
    }

}
